%define rescan_version 1.56
%define rescan_script rescan-scsi-bus.sh

Summary: Utilities for devices that use SCSI command sets
Name: sg3_utils
Version: 1.36
%define base_release .2
Release: 1%{?dist}%{?base_release}
License: GPLv2+ and BSD
Group: Applications/System
Source0: http://sg.danny.cz/sg/p/sg3_utils-%{version}.tgz
Source1: http://www.garloff.de/kurt/linux/%{rescan_script}-%{rescan_version}
Source999: fivextra.tar.bz2
Patch0: rescan-scsi-bus-fixes.patch
URL: http://sg.danny.cz/sg/sg3_utils.html
Requires: %{name}-libs = %{version}-%{release}


%description
Collection of Linux utilities for devices that use the SCSI command set.
Includes utilities to copy data based on "dd" syntax and semantics (called
sg_dd, sgp_dd and sgm_dd); check INQUIRY data and VPD pages (sg_inq); check
mode and log pages (sginfo, sg_modes and sg_logs); spin up and down
disks (sg_start); do self tests (sg_senddiag); and various other functions.
See the README, CHANGELOG and COVERAGE files. Requires the linux kernel 2.4
series or later. In the 2.4 series SCSI generic device names (e.g. /dev/sg0)
must be used. In the 2.6 series other device names may be used as
well (e.g. /dev/sda).

Warning: Some of these tools access the internals of your system
and the incorrect usage of them may render your system inoperable.

%package libs
Summary: Shared library for %{name}
Group: System Environment/Libraries

%description libs
This package contains the shared library for %{name}.

%package devel
Summary: Development library and header files for the sg3_utils library
Group: Development/Libraries
Requires: %{name}-libs = %{version}-%{release}
Requires: glibc-headers

%description devel
This package contains the %{name} library and its header files for
developing applications.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name} 

%prep
%setup -q -a 999

# rescan-scsi-bus.sh
cp -p %{SOURCE1} %{rescan_script}
# apply fixes
%patch0 -p1


%build
%configure --disable-static

# Don't use rpath!
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT/%{_libdir}/*.la

install -p -m 755 %{rescan_script} $RPM_BUILD_ROOT%{_bindir}
( cd $RPM_BUILD_ROOT%{_bindir}; ln -sf %{rescan_script} scsi-rescan )

# Steps to package the sg3_utils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig


%files
%doc ChangeLog COVERAGE CREDITS INSTALL README README.sg_start
%{_bindir}/*
%{_mandir}/man8/*

%files libs
%doc BSD_LICENSE COPYING
%{_libdir}/*.so.*

%files devel
%{_includedir}/scsi/*.h
%{_libdir}/*.so

%files fivextra
%{prefix}

%changelog
* Fri Jul 05 2013 baseuser@ibm.com
- Base-8.x spec file
