Summary: A set of basic GNU tools commonly used in shell scripts
Name:    coreutils
Version: 8.21
%define base_release .5
Release: 11%{?dist}%{?base_release}
License: GPLv3+
Group:   System Environment/Base
Url:     http://www.gnu.org/software/coreutils/
Source0: ftp://ftp.gnu.org/gnu/%{name}/%{name}-%{version}.tar.xz
Source101:  coreutils-DIR_COLORS
Source102:  coreutils-DIR_COLORS.lightbgcolor
Source103:  coreutils-DIR_COLORS.256color
Source105:  coreutils-colorls.sh
Source106:  coreutils-colorls.csh
Source999:  fivextra.tar.bz2

# From upstream
Patch1: coreutils-8.21-install-strip.patch
Patch2: coreutils-aarch64-longlong.patch

# Our patches
#general patch to workaround koji build system issues
Patch100: coreutils-6.10-configuration.patch
#add note about no difference between binary/text mode on Linux - md5sum manpage
Patch101: coreutils-6.10-manpages.patch
#temporarily workaround probable kernel issue with TCSADRAIN(#504798)
Patch102: coreutils-7.4-sttytcsadrain.patch
#do display processor type for uname -p/-i based on uname(2) syscall
Patch103: coreutils-8.2-uname-processortype.patch
#df --direct
Patch104: coreutils-df-direct.patch
#add note about mkdir --mode behaviour into info documentation(#610559)
Patch107: coreutils-8.4-mkdir-modenote.patch

# sh-utils
#add info about TZ envvar to date manpage
Patch703: sh-utils-2.0.11-dateman.patch
Patch713: coreutils-4.5.3-langinfo.patch

# (sb) lin18nux/lsb compliance - multibyte functionality patch
Patch800: coreutils-i18n.patch

#getgrouplist() patch from Ulrich Drepper.
Patch908: coreutils-getgrouplist.patch
#Prevent buffer overflow in who(1) (bug #158405).
Patch912: coreutils-overflow.patch

#SELINUX Patch - implements Redhat changes
#(upstream did some SELinux implementation unlike with RedHat patch)
Patch950: coreutils-selinux.patch
Patch951: coreutils-selinuxmanpages.patch
#Deprecate cp -Z/--context non-upstream option
Patch952: coreutils-cpZ-deprecate.patch

# LTC patches
Patch92287: bug-92287-disable-perl-help2man.patch

Conflicts: filesystem < 3
Provides: /bin/basename
Provides: /bin/cat
Provides: /bin/chgrp
Provides: /bin/chmod
Provides: /bin/chown
Provides: /bin/cp
Provides: /bin/cut
Provides: /bin/date
Provides: /bin/dd
Provides: /bin/df
Provides: /bin/echo
Provides: /bin/env
Provides: /bin/false
Provides: /bin/ln
Provides: /bin/ls
Provides: /bin/mkdir
Provides: /bin/mknod
Provides: /bin/mktemp
Provides: /bin/mv
Provides: /bin/nice
Provides: /bin/pwd
Provides: /bin/readlink
Provides: /bin/rm
Provides: /bin/rmdir
Provides: /bin/sleep
Provides: /bin/sort
Provides: /bin/stty
Provides: /bin/sync
Provides: /bin/touch
Provides: /bin/true
Provides: /bin/uname

BuildRequires: libselinux-devel
BuildRequires: libacl-devel
BuildRequires: gettext bison
BuildRequires: texinfo
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libcap-devel
BuildRequires: libattr-devel
BuildRequires: gmp-devel
BuildRequires: attr
BuildRequires: strace

Requires(pre): /sbin/install-info
Requires(preun): /sbin/install-info
Requires(post): /sbin/install-info
Requires(post): grep
Requires:       ncurses
Requires:       gmp

Provides: fileutils = %{version}-%{release}
Provides: sh-utils = %{version}-%{release}
Provides: stat = %{version}-%{release}
Provides: textutils = %{version}-%{release}
#old mktemp package had epoch 3, so we have to use 4 for coreutils
Provides: mktemp = 4:%{version}-%{release}
Provides: bundled(gnulib)
Obsoletes: mktemp < 4:%{version}-%{release}
Obsoletes: fileutils <= 4.1.9
Obsoletes: sh-utils <= 2.0.12
Obsoletes: stat <= 3.3
Obsoletes: textutils <= 2.0.21
#coreutils-libs dropped in f17
Obsoletes: coreutils-libs < 8.13
#require util-linux >=2.22.1-3 to prevent lack of su/runuser on system
Requires: util-linux >= 2.22.1-3

%description
These are the GNU core utilities.  This package is the combination of
the old GNU fileutils, sh-utils, and textutils packages.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp
Requires: expect

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999

# From upstream
%patch1 -p1 -b .strip
%patch2 -p1 -b .aarch64

# Our patches
%patch100 -p1 -b .configure
%patch101 -p1 -b .manpages
%patch102 -p1 -b .tcsadrain
%patch103 -p1 -b .sysinfo
%patch104 -p1 -b .dfdirect
%patch107 -p1 -b .mkdirmode

# sh-utils
%patch703 -p1 -b .dateman
%patch713 -p1 -b .langinfo

# li18nux/lsb
%patch800 -p1 -b .i18n

# Coreutils
%patch908 -p1 -b .getgrouplist
%patch912 -p1 -b .overflow

#SELinux
%patch950 -p1 -b .selinux
%patch951 -p1 -b .selinuxman
%patch952 -p1 -b .cpZ

# LTC: use dummy-help2man since the perl help2man doesn't run well during cross.
%{?cross_build:%patch92287 -p1}

chmod a+x tests/misc/sort-mb-tests.sh tests/df/direct.sh || :

#fix typos/mistakes in localized documentation(#439410, #440056)
find ./po/ -name "*.p*" | xargs \
 sed -i \
 -e 's/-dpR/-cdpR/'

%build
export CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing -fpic"
%{expand:%%global optflags %{optflags} -D_GNU_SOURCE=1}
#autoreconf -i -v
touch aclocal.m4 configure config.hin Makefile.in */Makefile.in
aclocal -I m4
autoconf --force
automake --copy --add-missing
%configure --enable-largefile \
           %{?!noselinux:--enable-selinux} \
           --enable-install-program=hostname,arch \
           --with-tty-group \
           DEFAULT_POSIX2_VERSION=200112 alternative=199209 || :

# Regenerate manpages
touch man/*.x

make all %{?_smp_mflags}

# XXX docs should say /var/run/[uw]tmp not /etc/[uw]tmp
sed -i -e 's,/etc/utmp,/var/run/utmp,g;s,/etc/wtmp,/var/run/wtmp,g' doc/coreutils.texi

pushd fivextra
make all
popd

%check
make check

%install
make DESTDIR=$RPM_BUILD_ROOT install

# man pages are not installed with make install
make mandir=$RPM_BUILD_ROOT%{_mandir} install-man

# fix japanese catalog file
if [ -d $RPM_BUILD_ROOT%{_datadir}/locale/ja_JP.EUC/LC_MESSAGES ]; then
   mkdir -p $RPM_BUILD_ROOT%{_datadir}/locale/ja/LC_MESSAGES
   mv $RPM_BUILD_ROOT%{_datadir}/locale/ja_JP.EUC/LC_MESSAGES/*mo \
      $RPM_BUILD_ROOT%{_datadir}/locale/ja/LC_MESSAGES
   rm -rf $RPM_BUILD_ROOT%{_datadir}/locale/ja_JP.EUC
fi

bzip2 -9f ChangeLog

# let be compatible with old fileutils, sh-utils and textutils packages :
mkdir -p $RPM_BUILD_ROOT{%{_bindir},%{_sbindir}}

# chroot was in /usr/sbin :
mv $RPM_BUILD_ROOT{%_bindir,%_sbindir}/chroot

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/profile.d
install -p -c -m644 %SOURCE101 $RPM_BUILD_ROOT%{_sysconfdir}/DIR_COLORS
install -p -c -m644 %SOURCE102 $RPM_BUILD_ROOT%{_sysconfdir}/DIR_COLORS.lightbgcolor
install -p -c -m644 %SOURCE103 $RPM_BUILD_ROOT%{_sysconfdir}/DIR_COLORS.256color
install -p -c -m644 %SOURCE105 $RPM_BUILD_ROOT%{_sysconfdir}/profile.d/colorls.sh
install -p -c -m644 %SOURCE106 $RPM_BUILD_ROOT%{_sysconfdir}/profile.d/colorls.csh

# These come from util-linux and/or procps.
for i in hostname uptime kill ; do
    rm $RPM_BUILD_ROOT{%{_bindir}/$i,%{_mandir}/man1/$i.1}
done

# Compress ChangeLogs from before the fileutils/textutils/etc merge
bzip2 -f9 old/*/C*

# Use hard links instead of symbolic links for LC_TIME files (bug #246729).
find %{buildroot}%{_datadir}/locale -type l | \
(while read link
 do
   target=$(readlink "$link")
   rm -f "$link"
   ln "$(dirname "$link")/$target" "$link"
 done)

# Steps to package the acpid tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %name

# (sb) Deal with Installed (but unpackaged) file(s) found
rm -f $RPM_BUILD_ROOT%{_infodir}/dir

%pre
# We must deinstall these info files since they're merged in
# coreutils.info. else their postun'll be run too late
# and install-info will fail badly because of duplicates
for file in sh-utils textutils fileutils; do
  if [ -f %{_infodir}/$file.info.gz ]; then
    /sbin/install-info --delete %{_infodir}/$file.info.gz --dir=%{_infodir}/dir &> /dev/null || :
  fi
done

%preun
if [ $1 = 0 ]; then
  if [ -f %{_infodir}/%{name}.info.gz ]; then
    /sbin/install-info --delete %{_infodir}/%{name}.info.gz %{_infodir}/dir || :
  fi
fi

%post
%{_bindir}/grep -v '(sh-utils)\|(fileutils)\|(textutils)' %{_infodir}/dir > \
  %{_infodir}/dir.rpmmodify || exit 0
    /bin/mv -f %{_infodir}/dir.rpmmodify %{_infodir}/dir
if [ -f %{_infodir}/%{name}.info.gz ]; then
  /sbin/install-info %{_infodir}/%{name}.info.gz %{_infodir}/dir || :
fi

%files -f %{name}.lang
%defattr(-,root,root,-)
%dir %{_datadir}/locale/*/LC_TIME
%config(noreplace) %{_sysconfdir}/DIR_COLORS*
%config(noreplace) %{_sysconfdir}/profile.d/*
%doc COPYING ABOUT-NLS ChangeLog.bz2 NEWS README THANKS TODO old/*
%{_bindir}/arch
%{_bindir}/basename
%{_bindir}/cat
%{_bindir}/chgrp
%{_bindir}/chmod
%{_bindir}/chown
%{_bindir}/cp
%{_bindir}/cut
%{_bindir}/date
%{_bindir}/dd
%{_bindir}/df
%{_bindir}/echo
%{_bindir}/env
%{_bindir}/false
%{_bindir}/link
%{_bindir}/ln
%{_bindir}/ls
%{_bindir}/mkdir
%{_bindir}/mknod
%{_bindir}/mv
%{_bindir}/nice
%{_bindir}/pwd
%{_bindir}/readlink
%{_bindir}/rm
%{_bindir}/rmdir
%{_bindir}/sleep
%{_bindir}/sort
%{_bindir}/stty
%{_bindir}/sync
%{_bindir}/mktemp
%{_bindir}/touch
%{_bindir}/true
%{_bindir}/uname
%{_bindir}/unlink
%{_bindir}/[
%{_bindir}/base64
%{_bindir}/chcon
%{_bindir}/cksum
%{_bindir}/comm
%{_bindir}/csplit
%{_bindir}/dir
%{_bindir}/dircolors
%{_bindir}/dirname
%{_bindir}/du
%{_bindir}/expand
%{_bindir}/expr
%{_bindir}/factor
%{_bindir}/fmt
%{_bindir}/fold
%{_bindir}/groups
%{_bindir}/head
%{_bindir}/hostid
%{_bindir}/id
%{_bindir}/install
%{_bindir}/join
%{_bindir}/logname
%{_bindir}/md5sum
%{_bindir}/mkfifo
%{_bindir}/nl
%{_bindir}/nohup
%{_bindir}/nproc
%{_bindir}/numfmt
%{_bindir}/od
%{_bindir}/paste
%{_bindir}/pathchk
%{_bindir}/pinky
%{_bindir}/pr
%{_bindir}/printenv
%{_bindir}/printf
%{_bindir}/ptx
%{_bindir}/realpath
%{_bindir}/runcon
%{_bindir}/seq
%{_bindir}/sha1sum
%{_bindir}/sha224sum
%{_bindir}/sha256sum
%{_bindir}/sha384sum
%{_bindir}/sha512sum
%{_bindir}/shred
%{_bindir}/shuf
%{_bindir}/split
%{_bindir}/stat
%{_bindir}/stdbuf
%{_bindir}/sum
%{_bindir}/tac
%{_bindir}/tail
%{_bindir}/tee
%{_bindir}/test
%{_bindir}/timeout
%{_bindir}/tr
%{_bindir}/truncate
%{_bindir}/tsort
%{_bindir}/tty
%{_bindir}/unexpand
%{_bindir}/uniq
%{_bindir}/users
%{_bindir}/vdir
%{_bindir}/wc
%{_bindir}/who
%{_bindir}/whoami
%{_bindir}/yes
%{_infodir}/coreutils*
%{_libexecdir}/coreutils*
%{_mandir}/man*/*
%{_sbindir}/chroot

%files fivextra
%{prefix}

%changelog
* Fri May 31 2013 baseuser@ibm.com
- Base-8.x spec file
