Name: sheepdog
Summary: The Sheepdog Distributed Storage System for KVM/QEMU
Version: 0.3.0
%define base_release .3
Release: 4%{?dist}%{?base_release}
License: GPLv2 and GPLv2+
Group: System Environment/Base
URL: http://www.osrg.net/sheepdog
Source0: collie-sheepdog-v0.3.0-0-gbb41896.tar.gz
#get source from github here https://github.com/collie/sheepdog/tarball/v0.3.0
Source1: sheepdog.service
Patch0: update_cpg_to_cs_defines.patch

# Runtime bits
Requires: corosync 
Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): initscripts
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
Requires(post): systemd-sysv

# Build bits
BuildRequires: autoconf automake systemd-units
BuildRequires: corosync corosynclib corosynclib-devel

BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

ExcludeArch: mips64 ppca2 ppc476 ppcnf

%description
This package contains the Sheepdog server, and command line tool which offer
a distributed object storage system for KVM.

%prep
%setup -qn collie-sheepdog-bb41896
%patch0 -p1

%build
./autogen.sh
%{configure} --with-initddir=%{_initrddir}

make %{_smp_mflags}
%install
rm -rf %{buildroot}

make install DESTDIR=%{buildroot}
mkdir -p %{buildroot}/%{_unitdir}
cp -a %{SOURCE1} %{buildroot}/%{_unitdir}/
## tree fixup
# drop static libs
rm -f %{buildroot}%{_libdir}/*.a
rm -f %{buildroot}%{_initddir}/sheepdog
%clean
rm -rf %{buildroot}

%post
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable sheepdog.service > /dev/null 2>&1 || :
    /bin/systemctl stop sheepdog.service > /dev/null 2>&1 || :
fi

%postun
%triggerun -- sheepdog < 0.2.4-2
/usr/bin/systemd-sysv-convert --save httpd >/dev/null 2>&1 ||:
/sbin/chkconfig --del httpd >/dev/null 2>&1 || :
/bin/systemctl try-restart sheepdog.service >/dev/null 2>&1 || :
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart sheepdog.service >/dev/null 2>&1 || :
fi

%files
%defattr(-,root,root,-)
%doc COPYING README INSTALL
%{_sbindir}/sheep
%{_sbindir}/collie
#%attr(755,-,-)%config %{_initddir}/sheepdog
%{_unitdir}/sheepdog.service
%dir %{_localstatedir}/lib/sheepdog
%{_mandir}/man8/sheep.8*

%changelog
* Tue Jun 25 2013 baseuser@ibm.com
- Base-8.x spec file
