Name: libaio
Version: 0.3.109
%define base_release .4
Release: 7%{?dist}%{?base_release}
Summary: Linux-native asynchronous I/O access library
License: LGPLv2+
Group:  System Environment/Libraries
Source: ftp://ftp.kernel.org/pub/linux/libs/aio/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2
BuildRoot: %{_tmppath}/%{name}-root
Patch1: libaio-install-to-slash.patch
Patch2: libaio-sparc.patch

%description
The Linux-native asynchronous I/O facility ("async I/O", or "aio") has a
richer API and capability set than the simple POSIX async I/O facility.
This library, libaio, provides the Linux-native API for async I/O.
The POSIX async I/O facility requires this library in order to provide
kernel-accelerated async I/O capabilities, as do applications which
require the Linux-native async I/O API.

%define libdir /%{_lib}
%define usrlibdir %{_prefix}/%{_lib}

%package devel
Summary: Development files for Linux-native asynchronous I/O access
Group: Development/System
Requires: libaio

%description devel
This package provides header files to include and libraries to link with
for the Linux-native asynchronous I/O facility ("async I/O", or "aio").

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
BuildRequires: ltp
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -a 0 -a 999
%patch1 -p1
mv %{name}-%{version} compat-%{name}-%{version}
%patch2 -p1

%build
# A library with a soname of 1.0.0 was inadvertantly released.  This
# build process builds a version of the library with the broken soname in
# the compat-libaio-0.3.103 directory, and then builds the library again
# with the correct soname.
export CC=%{__cc}
cd compat-%{name}-%{version}
make soname='libaio.so.1.0.0' libname='libaio.so.1.0.0'
cd ..
make

pushd fivextra
make all
popd

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
cd compat-%{name}-%{version}
install -D -m 755 src/libaio.so.1.0.0 \
  $RPM_BUILD_ROOT/%{libdir}/libaio.so.1.0.0
cd ..
make destdir=$RPM_BUILD_ROOT prefix=/ libdir=%{libdir} usrlibdir=%{usrlibdir} \
	includedir=%{_includedir} install

# Steps to package the libaio tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
       install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
       install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 

install -d $RPM_BUILD_ROOT/opt/fiv/ltp/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%attr(0755,root,root) %{libdir}/libaio.so.*
%doc COPYING TODO

%files devel
%defattr(-,root,root)
%attr(0644,root,root) %{_includedir}/*
%attr(0755,root,root) %{usrlibdir}/libaio.so*
%exclude %{_libdir}/libaio.a

%files fivextra
%{prefix}

%changelog
* Mon Jun 10 2013 baseuser@ibm.com
- Base-8.x spec file
