# For cross, disable python unless --with is specified.
%if 0%{?cross_build}
%bcond_with python
%else
%bcond_without python
%endif

%if 0%{?with_python}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%endif

Name: libuser
Version: 0.59
%define base_release .5
Release: 1%{?dist}%{?base_release}
Group: System Environment/Base
License: LGPLv2+
URL: https://fedorahosted.org/libuser/
Source: https://fedorahosted.org/releases/l/i/libuser/libuser-%{version}.tar.xz
Source999: fivextra.tar.bz2
BuildRequires: glib2-devel, %{!?fedora:linuxdoc-tools,} pam-devel, popt-devel
%{?with_python:BuildRequires: python2-devel}
BuildRequires: cyrus-sasl-devel, libselinux-devel, openldap-devel
# To make sure the configure script can find it
BuildRequires: nscd
# For %%check
BuildRequires: fakeroot, openldap-clients, openldap-servers, openssl
Summary: A user and group account administration library

%description
The libuser library implements a standardized interface for manipulating
and administering user and group accounts.  The library uses pluggable
back-ends to interface to its data sources.

Sample applications modeled after those included with the shadow password
suite are included.

%package devel
Group: Development/Libraries
Summary: Files needed for developing applications which use libuser
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: glib2-devel%{?_isa}

%description devel
The libuser-devel package contains header files, static libraries, and other
files useful for developing applications with libuser.

%if 0%{?with_python}
%package python
Summary: Python bindings for the libuser library
Group: Development/Libraries
Requires: libuser%{?_isa} = %{version}-%{release}

%description python
The libuser-python package contains the Python bindings for
the libuser library, which provides a Python API for manipulating and
administering user and group accounts.
%endif # end with_python

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: libuser-python, fakeroot

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%build
%configure --with-selinux --with-ldap %{!?fedora:--with-html-dir=%{_datadir}/gtk-doc/html} \
        %{?fedora:--enable-gtk-doc-html=no} \
	%{?with_python:--with-python}%{!?with_python:--without-python}

# LTC: Disable docs. texlive is way to big to bring in considering we don't care about these docs.
%{?fedora:sed -i '/^SUBDIRS.*docs/ s/docs//g' Makefile}
make
make check || true

pushd fivextra
make all
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL='install -p'

# Steps to package the libuser tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
 install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find tests -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 2 \
-name '*.c' -o -name '*.h' -o -name '*.o' -o -name 'Makefile*' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 

%find_lang %{name}

%check
# LTC: we fail fs_test; i think it's due to our chrooted env, but we should see if
# we can run at least some of these tests in the future.
%{!?fedora:make check}

# Verify that all python modules load, just in case.
LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_libdir}:${LD_LIBRARY_PATH}
export LD_LIBRARY_PATH
cd $RPM_BUILD_ROOT/%{python_sitearch}
python -c "import libuser"

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -f %{name}.lang
%doc AUTHORS COPYING NEWS README TODO docs/*.txt
%config(noreplace) %{_sysconfdir}/libuser.conf

%attr(0755,root,root) %{_bindir}/*
%{_libdir}/*.so.*
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/*.so
%attr(0755,root,root) %{_sbindir}/*
%{_mandir}/man1/*
%{!?fedora:%{_mandir}/man5/*}

%exclude %{_libdir}/*.la
%exclude %{_libdir}/%{name}/*.la

%if 0%{?with_python}
%files python
%doc python/modules.txt
%{python_sitearch}/*.so
%exclude %{python_sitearch}/*.la
%endif # end with_python

%files devel
%{_includedir}/libuser
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%{!?fedora:%{_datadir}/gtk-doc/html/*}

%files fivextra
%{prefix}

%changelog
* Tue May 14 2013 baseuser@ibm.com
- Base-8.x spec file
