Name: kexec-tools
Version: 2.0.4
%define base_release .8
Release: 2%{?dist}%{?base_release}
License: GPLv2
Group: Applications/System
Summary: The kexec/kdump userspace component.
Source0: http://kernel.org/pub/linux/utils/kernel/kexec/%{name}-%{version}.tar.bz2
Source1: kdumpctl
Source2: kdump.sysconfig
Source3: kdump.sysconfig.x86_64
Source4: kdump.sysconfig.i386
Source5: kdump.sysconfig.ppc64
Source6: kdump.sysconfig.ia64
Source7: mkdumprd
Source8: kdump.conf
Source9: http://downloads.sourceforge.net/project/makedumpfile/makedumpfile/1.5.3/makedumpfile-1.5.3.tar.gz
Source10: kexec-kdump-howto.txt
Source11: firstboot_kdump.py
Source12: mkdumprd.8
Source13: kexec-tools-po.tar.gz
Source14: 98-kexec.rules
Source15: kdump.conf.5
Source16: kdump.service
Source17: rhcrashkernel-param
Source18: kdump.sysconfig.s390x
Source19: eppic_030413.tar.gz
Source20: kdump.sysconfig.ppcnf

#######################################
# These are sources for mkdumpramfs
# Which is currently in development
#######################################
Source100: dracut-kdump.sh
Source101: dracut-module-setup.sh
Source102: dracut-monitor_dd_progress
Source999: fivextra.tar.bz2

Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
Requires(pre): coreutils sed zlib 
Requires: dracut, dracut-network, ethtool
BuildRequires: zlib-devel zlib zlib-static elfutils-devel-static glib2-devel bzip2-devel ncurses-devel bison flex
BuildRequires: pkgconfig intltool gettext 
BuildRequires: systemd-units
%ifarch %{ix86} x86_64 ppc64 ia64 ppc s390x ppc476 ppcnf
Obsoletes: diskdumputils netdump
%endif


#START INSERT

#
# Patches 0 through 100 are meant for x86 kexec-tools enablement
#

#
# Patches 101 through 200 are meant for x86_64 kexec-tools enablement
#

#
# Patches 201 through 300 are meant for ia64 kexec-tools enablement
#

#
# Patches 301 through 400 are meant for ppc64 kexec-tools enablement
#

#
# Patches 401 through 500 are meant for s390 kexec-tools enablement
#
#
# Patches 501 through 600 are meant for ppc kexec-tools enablement
#

#
# Patches 601 onward are generic patches
#
Patch601: kexec-tools-2.0.3-disable-kexec-test.patch
Patch604: kexec-tools-2.0.3-build-makedumpfile-eppic-shared-object.patch

#bug patches

# Integrate RAS feature makedumpfile enhancements into kexec-tools for zFPC
# Alpha3
Patch10085601: bug-10085601-module-sym.patch
Patch10085602: bug-10085602-module-struct.patch
Patch10085603: bug-10085603-fix-erase_ch.patch
Patch10085604: bug-10085604-fix-close-dwfl-handle.patch
Patch10085605: bug-10085605-warn-on.patch
Patch10085606: bug-10085606-module-second-level.patch
Patch10085611: bug-10085611-proc-names.patch
Patch10085612: bug-10085612-dir-names.patch
Patch10085613: bug-10085613-keyring.patch
Patch10085614: bug-10085614-ap_messages.patch
Patch10085615: bug-10085615-tcp_buffers.patch
Patch10085616: bug-10085616-udp_buffers.patch
Patch10085617: bug-10085617-unix_buffers.patch
Patch10085618: bug-10085618-vhost_net.patch
Patch10085619: bug-10085619-vhost_scsi.patch
Patch10085620: bug-10085620-install.patch

# Frobisher patches
Patch10375201: bug-10375201-kexec-tools-2.0.3-kexec-fix_fs2dt.patch
Patch10375202: bug-10375202-kexec-tools-2.0.3-kexec-kdump_fix.patch
Patch10375203: bug-10375203-kexec-tools-2.0.3-kexec-ppc64-opal-debug.patch
Patch10375204: bug-10375204-kexec-tools-2.0.3-kexec-reserved_region.patch
Patch10375205: bug-10375205-kexec-tools-2.0.3-makedumpfile-change_reader_writer.patch
Patch10375206: bug-10375206-kexec-tools-2.0.3-makedumpfile-fix-overlapped-segments.patch
Patch10375207: bug-10375207-kexec-tools-2.0.3-makedumpfile-introduce_new_symbol_vmap_area.patch
Patch10375208: bug-10375208-kexec-tools-2.0.3-makedumpfile-add_vmap_area_list.patch
Patch10375209: bug-10375209-kexec-tools-2.0.3-makedumpfile-vmemmap-support.patch
Patch103670: bug-103670-exec-tools-2.0.4-build-makedumpfile-allow-large-page.patch
Patch10411801: bug104118.random.seed.patch
Patch10411802: bug104118.huge.memory.patch
Patch10472201: bug-10472201-fix-vhost-net.patch
Patch10472202: bug-10472202-fix-vhost-scsi.patch
Patch10472203: bug-10472203-makedumpfile-properly-resolve-structure-members.patch
Patch107900: bug-107900-fix-non-zero.patch
Patch111509: bug111509-disable.rate.limit.patch

#Cross build modification
Patch999:crossbuild.patch

%description
kexec-tools provides /sbin/kexec binary that facilitates a new
kernel to boot using the kernel's kexec feature either on a
normal or a panic reboot. This package contains the /sbin/kexec
binary and ancillary utilities that together form the userspace
component of the kernel's kexec feature.

%ifarch %{ix86} x86_64 ia64 ppc64 s390x ppc476 ppcnf
%package eppic
Requires: %{name} = %{version}
Summary: Additional eppic_makedumpfile.so shared object
Group: Applications/System

%description eppic
The eppic_makedumpfile.so shared object is loaded by the
"makedumpfile --eppic" option, and is used to erase sensitive
or confidential kernel data from a dumpfile.
%endif

%package fivextra 
Summary: Test for %{name} package
Group: fivextra

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999

mkdir -p -m755 kcp
tar -z -x -v -f %{SOURCE9}
tar -z -x -v -f %{SOURCE19}


%patch601 -p1
%patch604 -p1

%patch10085601 -p1
%patch10085602 -p1
%patch10085603 -p2
%patch10085604 -p2
%patch10085605 -p2
%patch10085606 -p2
%patch10085611 -p2
%patch10085612 -p2
%patch10085613 -p2
%patch10085614 -p2
%patch10085615 -p2
%patch10085616 -p2
%patch10085617 -p2
%patch10085618 -p2
%patch10085619 -p2
%patch10085620 -p2

# Frobisher patches
%patch10375201 -p1
%patch10375202 -p1
%patch10375203 -p1
%patch10375204 -p1
%patch10375205 -p1
%patch10375206 -p1
%patch10375207 -p1
%patch10375208 -p1
%patch10375209 -p1
%patch103670 -p1
%patch10411801 -d ../../SOURCES -p0
%patch10411802 -p1
%patch10472201 -p2
%patch10472202 -p2
%patch10472203 -p1
%patch107900 -p2
%patch111509 -d ../../SOURCES -p1

%patch999 -p1

tar -z -x -v -f %{SOURCE13}

%ifarch ppc
%define archdef ARCH=ppc
%endif

%build
%ifarch ia64
# ia64 gcc seems to have a problem adding -fexception -fstack-protect and
# -param ssp-protect-size, like the %configure macro does
# while that shouldn't be a problem, and it still builds fine, it results in
# the kdump kernel hanging on kexec boot.  I don't yet know why, but since those
# options aren't critical, I'm just overrideing them here for ia64
export CFLAGS="-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2"
%endif

[ ! -f ./configure ] && ./bootstrap
%configure \
%ifarch ppc64
    --host=powerpc64-redhat-linux-gnu \
    --build=powerpc64-redhat-linux-gnu \
%endif
%ifarch ppc476 ppcnf
    --with-booke       \
%endif
    --sbindir=/sbin
rm -f kexec-tools.spec.in
# setup the docs
cp %{SOURCE10} . 

make
%ifarch %{ix86} x86_64 ia64 ppc64 s390x ppc476 ppcnf
make -C eppic/libeppic CROSS_BUILD=0%{?cross_build}
make -C makedumpfile-1.5.3 LINKTYPE=dynamic TARGET=%{_arch}
%endif
make -C kexec-tools-po

%install
make install DESTDIR=$RPM_BUILD_ROOT
mkdir -p -m755 $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
mkdir -p -m755 $RPM_BUILD_ROOT%{_localstatedir}/crash
mkdir -p -m755 $RPM_BUILD_ROOT%{_mandir}/man8/
mkdir -p -m755 $RPM_BUILD_ROOT%{_mandir}/man5/
mkdir -p -m755 $RPM_BUILD_ROOT%{_docdir}
mkdir -p -m755 $RPM_BUILD_ROOT%{_datadir}/kdump
mkdir -p -m755 $RPM_BUILD_ROOT%{_sysconfdir}/udev/rules.d
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
mkdir -p -m755 $RPM_BUILD_ROOT%{_bindir}
mkdir -p -m755 $RPM_BUILD_ROOT%{_libdir}
install -m 755 %{SOURCE1} $RPM_BUILD_ROOT%{_bindir}/kdumpctl

# Touch all kdump.sysconfig files to ensure all source is included
# in the source subpackages for all architectures.
touch $RPM_SOURCE_DIR/kdump.sysconfig.*
touch $RPM_SOURCE_DIR/kdump.sysconfig

SYSCONFIG=$RPM_SOURCE_DIR/kdump.sysconfig.%{_target_cpu}
[ -f $SYSCONFIG ] || SYSCONFIG=$RPM_SOURCE_DIR/kdump.sysconfig.%{_arch}
[ -f $SYSCONFIG ] || SYSCONFIG=$RPM_SOURCE_DIR/kdump.sysconfig
install -m 644 $SYSCONFIG $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/kdump

install -m 755 %{SOURCE7} $RPM_BUILD_ROOT/sbin/mkdumprd
install -m 644 %{SOURCE8} $RPM_BUILD_ROOT%{_sysconfdir}/kdump.conf
install -m 644 kexec/kexec.8 $RPM_BUILD_ROOT%{_mandir}/man8/kexec.8
install -m 755 %{SOURCE11} $RPM_BUILD_ROOT%{_datadir}/kdump/firstboot_kdump.py
install -m 644 %{SOURCE12} $RPM_BUILD_ROOT%{_mandir}/man8/mkdumprd.8
install -m 644 %{SOURCE14} $RPM_BUILD_ROOT%{_sysconfdir}/udev/rules.d/98-kexec.rules
install -m 644 %{SOURCE15} $RPM_BUILD_ROOT%{_mandir}/man5/kdump.conf.5
install -m 644 %{SOURCE16} $RPM_BUILD_ROOT%{_unitdir}/kdump.service
mkdir -p $RPM_BUILD_ROOT/usr/sbin
install -m 755 %{SOURCE17} $RPM_BUILD_ROOT/usr/sbin/rhcrashkernel-param

%ifarch %{ix86} x86_64 ia64 ppc64 s390x ppc476 ppcnf
install -m 755 makedumpfile-1.5.3/makedumpfile $RPM_BUILD_ROOT/sbin/makedumpfile
install -m 644 makedumpfile-1.5.3/makedumpfile.8.gz $RPM_BUILD_ROOT/%{_mandir}/man8/makedumpfile.8.gz
install -m 755 makedumpfile-1.5.3/eppic_makedumpfile.so $RPM_BUILD_ROOT/%{_libdir}/eppic_makedumpfile.so
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/makedumpfile-1.5.3/eppic_scripts
install -m 644 makedumpfile-1.5.3/eppic_scripts/*.c $RPM_BUILD_ROOT/%{_datadir}/makedumpfile-1.5.3/eppic_scripts
%endif
make -C kexec-tools-po install DESTDIR=$RPM_BUILD_ROOT
%find_lang %{name}

%define remove_dracut_prefix() %(echo -n %1|sed 's/.*dracut-//g')

# deal with dracut modules
mkdir -p -m755 $RPM_BUILD_ROOT/etc/kdump-adv-conf/kdump_dracut_modules/99kdumpbase
cp %{SOURCE100} $RPM_BUILD_ROOT/etc/kdump-adv-conf/kdump_dracut_modules/99kdumpbase/%{remove_dracut_prefix %{SOURCE100}}
cp %{SOURCE101} $RPM_BUILD_ROOT/etc/kdump-adv-conf/kdump_dracut_modules/99kdumpbase/%{remove_dracut_prefix %{SOURCE101}}
cp %{SOURCE102} $RPM_BUILD_ROOT/etc/kdump-adv-conf/kdump_dracut_modules/99kdumpbase/%{remove_dracut_prefix %{SOURCE102}}

chmod 755 $RPM_BUILD_ROOT/etc/kdump-adv-conf/kdump_dracut_modules/99kdumpbase/%{remove_dracut_prefix %{SOURCE100}}
chmod 755 $RPM_BUILD_ROOT/etc/kdump-adv-conf/kdump_dracut_modules/99kdumpbase/%{remove_dracut_prefix %{SOURCE101}}


%define dracutlibdir %{_prefix}/lib/dracut
#and move the custom dracut modules to the dracut directory
mkdir -p $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/
mv $RPM_BUILD_ROOT/etc/kdump-adv-conf/kdump_dracut_modules/* $RPM_BUILD_ROOT/%{dracutlibdir}/modules.d/

# Steps to package kexec-tools test for FIV
for dir in `cd fivextra/%{name}; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/%{name}/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

# Steps to package kdump test for FIV
for dir in `cd fivextra/kdump; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/kdump/$dir
  install -m 755 `find fivextra/kdump/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/kdump/$dir
done

if [ -f /sys/hypervisor/type ] && grep -q "xen" /sys/hypervisor/type
then
       # We need to put some garbage in the kdump.conf file
       echo "Kdump_not_supported_on_Xen_domU_guest" >> /etc/kdump.conf 
fi


%post
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl enable kdump.service >/dev/null 2>&1 || :
fi
touch /etc/kdump.conf
# This portion of the script is temporary.  Its only here
# to fix up broken boxes that require special settings 
# in /etc/sysconfig/kdump.  It will be removed when 
# These systems are fixed.

if [ -d /proc/bus/mckinley ]
then
	# This is for HP zx1 machines
	# They require machvec=dig on the kernel command line
	sed -e's/\(^KDUMP_COMMANDLINE_APPEND.*\)\("$\)/\1 machvec=dig"/' \
	/etc/sysconfig/kdump > /etc/sysconfig/kdump.new
	mv /etc/sysconfig/kdump.new /etc/sysconfig/kdump
elif [ -d /proc/sgi_sn ]
then
	# This is for SGI SN boxes
	# They require the --noio option to kexec 
	# since they don't support legacy io
	sed -e's/\(^KEXEC_ARGS.*\)\("$\)/\1 --noio"/' \
	/etc/sysconfig/kdump > /etc/sysconfig/kdump.new
	mv /etc/sysconfig/kdump.new /etc/sysconfig/kdump
fi


%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart kdump.service >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable kdump.service > /dev/null 2>&1 || :
    /bin/systemctl stop kdump.service > /dev/null 2>&1 || :
fi

%triggerun -- kexec-tools < 2.0.2-3
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply kdump
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save kdump >/dev/null 2>&1 ||:

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del kdump >/dev/null 2>&1 || :
/bin/systemctl try-restart kdump.service >/dev/null 2>&1 || :


%triggerin -- firstboot
# we enable kdump everywhere except for paravirtualized xen domains; check here
if [ -f /proc/xen/capabilities ]; then
	if [ -z `grep control_d /proc/xen/capabilities` ]; then
		exit 0
	fi
fi
if [ ! -e %{_datadir}/firstboot/modules/firstboot_kdump.py ]
then
	ln -s %{_datadir}/kdump/firstboot_kdump.py %{_datadir}/firstboot/modules/firstboot_kdump.py
fi

%triggerin -- kernel-kdump
touch %{_sysconfdir}/kdump.conf


%triggerun -- firstboot
rm -f %{_datadir}/firstboot/modules/firstboot_kdump.py

%triggerpostun -- kernel kernel-xen kernel-debug kernel-PAE kernel-kdump
# List out the initrds here, strip out version nubmers
# and search for corresponding kernel installs, if a kernel
# is not found, remove the corresponding kdump initrd

#start by getting a list of all the kdump initrds
MY_ARCH=`uname -m`
if [ "$MY_ARCH" == "ia64" ]
then
	IMGDIR=/boot/efi/efi/redhat
else
	IMGDIR=/boot
fi

for i in `ls $IMGDIR/initramfs*kdump.img 2>/dev/null`
do
	KDVER=`echo $i | sed -e's/^.*initramfs-//' -e's/kdump.*$//'`
	if [ ! -e $IMGDIR/vmlinuz-$KDVER ]
	then
		# We have found an initrd with no corresponding kernel
		# so we should be able to remove it
		rm -f $i
	fi
done

%files -f %{name}.lang
/sbin/*
/usr/sbin/*
%{_bindir}/*
%{_datadir}/kdump
%config(noreplace,missingok) %{_sysconfdir}/sysconfig/kdump
%config(noreplace,missingok) %{_sysconfdir}/kdump.conf
%config %{_sysconfdir}/udev/rules.d/*
%{dracutlibdir}/modules.d/*
%dir %{_localstatedir}/crash
%{_mandir}/man8/*
%{_mandir}/man5/*
%{_unitdir}/kdump.service
%doc News
%doc COPYING
%doc TODO
%doc kexec-kdump-howto.txt

%ifarch %{ix86} x86_64 ia64 ppc64 s390x ppc476 ppcnf
%files eppic
%{_libdir}/eppic_makedumpfile.so
%{_datadir}/makedumpfile-1.5.3/eppic_scripts/*.c
%endif

%files fivextra
%{fivdir}

%changelog
* Thu Jan 23 2014 baseuser@ibm.com
- Base-f19.x spec file
