Summary: A dynamic adaptive system tuning daemon
Name: tuned
Version: 2.3.0
%define base_release .3
Release: 3%{?dist}%{?base_release}
License: GPLv2+
Source: https://fedorahosted.org/releases/t/u/tuned/tuned-%{version}.tar.bz2
URL: https://fedorahosted.org/tuned/
Patch0: tuned-2.3.0-fix-race.patch
Patch1: tuned-2.3.0-timing-improvements.patch
Patch1000: bug109680-cpu.frequency.helper.functions.patch
Patch1001: bug109680-enhance.cpu.profile.frequency.settings.patch
Patch1002: bug109680-patch1.patch
Patch1003: bug109680-patch2.patch
Patch1004: bug109680-patch3.patch
Patch1005: bug109680-patch4.patch
BuildArch: noarch
BuildRequires: python, systemd
Requires(post): systemd, virt-what
Requires(preun): systemd
Requires(postun): systemd
Requires: python-decorator, dbus-python, pygobject2, python-pyudev
Requires: virt-what, python-configobj, ethtool, gawk, kernel-tools

%description
The tuned package contains a daemon that tunes system settings dynamically.
It does so by monitoring the usage of several system components periodically.
Based on that information components will then be put into lower or higher
power saving modes to adapt to the current usage. Currently only ethernet
network and ATA harddisk devices are implemented.

%package utils
Requires: %{name} = %{version}-%{release}
Summary: Various tuned utilities
Requires: powertop

%description utils
This package contains utilities that can help you to fine tune your
system and manage tuned profiles.

%package utils-systemtap
Summary: Disk and net statistic monitoring systemtap scripts
Requires: %{name} = %{version}-%{release}
Requires: systemtap

%description utils-systemtap
This package contains several systemtap scripts to allow detailed
manual monitoring of the system. Instead of the typical IO/sec it collects
minimal, maximal and average time between operations to be able to
identify applications that behave power inefficient (many small operations
instead of fewer large ones).

%package profiles-compat
Summary: Additional tuned profiles mainly for backward compatibility with tuned 1.0
Requires: %{name} = %{version}-%{release}

%description profiles-compat
Additional tuned profiles mainly for backward compatibility with tuned 1.0.
It can be also used to fine tune your system for specific scenarios.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch1000 -p1
#%patch1001 -p1
#%patch1002 -p1
%patch1003 -p1
%patch1004 -p1
%patch1005 -p1

chmod 755 profiles/balanced/script.sh
chmod 755 profiles/latency-performance/script.sh
chmod 755 profiles/throughput-performance/script.sh

%build

%install
make install DESTDIR=%{buildroot}
%if 0%{?base}
sed -i 's/\(dynamic_tuning[ \t]*=[ \t]*\).*/\10/' %{buildroot}%{_sysconfdir}/tuned/tuned-main.conf
%endif

# move docs to unversioned directory
#mv %{buildroot}%{_docdir}/%{name}-%{version} %{buildroot}%{_docdir}/%{name}

%post
%systemd_post tuned.service

# try to autodetect the best profile for the system in case there is none preset
if [ ! -f /etc/tuned/active_profile -o -z "`cat /etc/tuned/active_profile 2>/dev/null`" ]
then
	PROFILE=`/usr/sbin/tuned-adm recommend 2>/dev/null`
	[ "$PROFILE" ] || PROFILE=balanced
	/usr/sbin/tuned-adm profile "$PROFILE" 2>/dev/null || echo -n "$PROFILE" > /etc/tuned/active_profile
fi

# convert active_profile from full path to name (if needed)
sed -i 's|.*/\([^/]\+\)/[^\.]\+\.conf|\1|' /etc/tuned/active_profile


%preun
%systemd_preun tuned.service


%postun
%systemd_postun_with_restart tuned.service


%triggerun -- tuned < 2.0-0
# remove ktune from old tuned, now part of tuned
/usr/sbin/service ktune stop &>/dev/null || :
/usr/sbin/chkconfig --del ktune &>/dev/null || :


%files
%defattr(-,root,root,-)
%doc AUTHORS
%doc COPYING
%doc README
%doc doc/TIPS.txt
%{_sysconfdir}/bash_completion.d
%{python_sitelib}/tuned
%{_sbindir}/tuned
%{_sbindir}/tuned-adm
%exclude %{_prefix}/lib/tuned/default
#%exclude %{_prefix}/lib/tuned/desktop-powersave
#%exclude %{_prefix}/lib/tuned/laptop-ac-powersave
%exclude %{_prefix}/lib/tuned/server-powersave
#%exclude %{_prefix}/lib/tuned/laptop-battery-powersave
%exclude %{_prefix}/lib/tuned/enterprise-storage
#%exclude %{_prefix}/lib/tuned/spindown-disk
%{_prefix}/lib/tuned
%dir %{_sysconfdir}/tuned
%config(noreplace) %{_sysconfdir}/tuned/active_profile
%config(noreplace) %{_sysconfdir}/tuned/tuned-main.conf
%{_sysconfdir}/tmpfiles.d
%{_sysconfdir}/dbus-1/system.d/com.redhat.tuned.conf
%{_unitdir}/tuned.service
%dir %{_localstatedir}/log/tuned
%dir /run/tuned
%{_mandir}/man5/tuned*
%{_mandir}/man8/tuned*

%files utils
%defattr(-,root,root,-)
%doc COPYING
%{_bindir}/powertop2tuned
%{_libexecdir}/tuned/pmqos-static*

%files utils-systemtap
%defattr(-,root,root,-)
%doc doc/README.utils
%doc doc/README.scomes
%doc COPYING
%{_sbindir}/varnetload
%{_sbindir}/netdevstat
%{_sbindir}/diskdevstat
%{_sbindir}/scomes
%{_mandir}/man8/varnetload.*
%{_mandir}/man8/netdevstat.*
%{_mandir}/man8/diskdevstat.*
%{_mandir}/man8/scomes.*

%files profiles-compat
%defattr(-,root,root,-)
%{_prefix}/lib/tuned/default
#%{_prefix}/lib/tuned/desktop-powersave
#%{_prefix}/lib/tuned/laptop-ac-powersave
%{_prefix}/lib/tuned/server-powersave
#%{_prefix}/lib/tuned/laptop-battery-powersave
%{_prefix}/lib/tuned/enterprise-storage
#%{_prefix}/lib/tuned/spindown-disk

%changelog
* Tue Dec 17 2013 baseuser@ibm.com
- Base-8.x spec file
