%if 0%{?fedora} && ! 0%{?base:1}
%global with_python3 1
%else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%endif

%if 0%{?fedora} && 0%{?fedora} <= 16
%{!?python3_version: %global python3_version %(%{__python3} -c 'import sys ; sys.stdout.write("%s.%s" % sys.version_info[:2])')}
%endif

Name: python-beaker
Version: 1.5.4
%define base_release .3
Release: 7%{?dist}%{?base_release}
Summary: WSGI middleware layer to provide sessions

Group: Development/Languages
License: BSD and MIT
URL: http://beaker.groovie.org/
Source0: http://pypi.python.org/packages/source/B/Beaker/Beaker-%{version}.tar.gz
Patch0: beaker-use-system-paste.patch
Patch1: beaker-disable-badtest.patch
Patch2: beaker-anydbm.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch: noarch
BuildRequires: python2-devel
BuildRequires: python-setuptools
# Needed for the test suite
BuildRequires: python-nose
BuildRequires: python-webtest
Requires: python-paste
%if 0%{?fedora}
Requires: pycryptopp
%else
Requires: python-crypto
%endif

%if 0%{?with_python3}
BuildRequires: /usr/bin/2to3
BuildRequires: python3-devel
BuildRequires: python3-setuptools
# Needed for complete test suite
#BuildRequires: python3-webtest
%if 0%{?fedora} > 14
BuildRequires: python3-nose
%endif
%endif # if with_python3

%description
Beaker is a caching library that includes Session and Cache objects built on
Myghty's Container API used in MyghtyUtils. WSGI middleware is also included to
manage Session objects and signed cookies.

%if 0%{?with_python3}
%package -n python3-beaker
Summary: WSGI middleware layer to provide sessions
Group: Development/Languages
# Paste is not python3 compatible at the moment
#Requires: python3-paste
# Without one of these there's no aes implementation which means there's no way to
# have encrypted cookies.  This is a reduction in features over the python2 version.
# Currently there's no working python3 port for either:
# http://allmydata.org/trac/pycryptopp/ticket/35
# http://lists.dlitz.net/pipermail/pycrypto/2010q2/000253.html
#%if 0%{?fedora}
#Requires: python3-pycryptopp
#%else
#Requires: python3-crypto
#%endif

%description -n python3-beaker
Beaker is a caching library that includes Session and Cache objects built on
Myghty's Container API used in MyghtyUtils. WSGI middleware is also included to
manage Session objects and signed cookies.
%endif # with_python3


%prep
%setup -q -n Beaker-%{version}
%patch0 -p1 -b .system
%patch1 -p1 -b .badtest
%patch2 -p1 -b .anydbm

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3


%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root $RPM_BUILD_ROOT
popd
%endif # with_python3


%check
PYTHONPATH=$(pwd) nosetests

#%%if 0%{?with_python3} && 0%{?fedora} > 14
#pushd %{py3dir}
#PYTHONPATH=$(pwd) nosetests-%{python3_version}
#popd
#%%endif

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc LICENSE CHANGELOG
%{python_sitelib}/beaker/
%{python_sitelib}/Beaker*

%if 0%{?with_python3}
%files -n python3-beaker
%defattr(-,root,root,-)
%{python3_sitelib}/beaker/
%{python3_sitelib}/Beaker*
%endif


%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
