%global tex_texinfo %{_datadir}/texmf/tex/texinfo

Summary: Tools needed to create Texinfo format documentation files
Name: texinfo
Version: 5.1
%define base_release .4
Release: 1%{?dist}%{?base_release}
License: GPLv3+
Group: Applications/Publishing
Url: http://www.gnu.org/software/texinfo/
Source0: ftp://ftp.gnu.org/gnu/texinfo/texinfo-%{version}.tar.xz
Source1: ftp://ftp.gnu.org/gnu/texinfo/texinfo-%{version}.tar.xz.sig
Source2: info-dir
Source999: fivextra.tar.bz2
Patch0: texinfo-4.12-zlib.patch
Patch1: texinfo-4.13a-powerpc.patch
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Requires: perl >= 5.7.3, perl(Text::Unidecode)
# Review Request for perl-Unicode-EastAsianWidth - bz874743
#Requires: perl(Unicode::EastAsianWidth)
BuildRequires: zlib-devel, ncurses-devel, help2man, perl(Data::Dumper)

%description
Texinfo is a documentation system that can produce both online
information and printed output from a single source file. The GNU
Project uses the Texinfo file format for most of its documentation.

Install texinfo if you want a documentation system for producing both
online and print documentation from the same source file and/or if you
are going to write documentation for the GNU Project.

%package -n info
Summary: A stand-alone TTY-based reader for GNU texinfo documentation
Group: System Environment/Base

%description -n info
The GNU project uses the texinfo file format for much of its
documentation. The info package provides a standalone TTY-based
browser program for viewing texinfo files.

%package tex
Summary: Tools for formatting Texinfo documentation files using TeX
Group: Applications/Publishing
Requires: texinfo = %{version}-%{release}
Requires: tex(tex) tex(epsf.tex)
Requires(post): %{_bindir}/texconfig-sys
Requires(postun): %{_bindir}/texconfig-sys

%description tex
Texinfo is a documentation system that can produce both online
information and printed output from a single source file. The GNU
Project uses the Texinfo file format for most of its documentation.

The texinfo-tex package provides tools to format Texinfo documents
for printing using TeX.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch0 -p1 -b .zlib
%patch1 -p1 -b .powerpc

%build
%configure --with-external-Text-Unidecode \
           %{!?cross_build:--with-external-libintl-perl} \
# line below - bz874743
#            --with-external-Unicode-EastAsianWidth
# Base - Need to force a make of libgnu during cross. Otherwise the target doesn't get
# made. See http://bugs.gentoo.org/196041 for details.
%if 0%{?cross_build}
make -C tools/gnulib/lib
%endif
make %{?_smp_mflags}

%install
mkdir -p ${RPM_BUILD_ROOT}/sbin

make install DESTDIR=$RPM_BUILD_ROOT INSTALL='install -p'

mkdir -p $RPM_BUILD_ROOT%{tex_texinfo}
install -p -m644 doc/texinfo.tex doc/txi-??.tex $RPM_BUILD_ROOT%{tex_texinfo}

install -p -m644 %{SOURCE2} $RPM_BUILD_ROOT%{_infodir}/dir
mv $RPM_BUILD_ROOT%{_bindir}/install-info $RPM_BUILD_ROOT/sbin

%find_lang %{name}
%find_lang %{name}_document

# Steps to package the texinfo tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in `cd makeinfo/tests; find .  -type d`
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/makeinfo/tests/$dir
 install -m 755 $(find makeinfo/tests/$dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/makeinfo/tests/$dir || true
done

for dir in `cd install-info/tests; find .  -type d`
do  
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/install-info/tests/$dir
 install -m 755 $(find install-info/tests/$dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/install-info/tests/$dir || true
done

install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/doc
install -m 755 doc/info.texi doc/texinfo.txi doc/version-stnd.texi doc/version.texi doc/info-stnd.texi doc/fdl.texi $RPM_BUILD_ROOT/%{fivdir}/%{name}/doc/

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
if [ -f %{_infodir}/texinfo.gz ]; then # --excludedocs?
    /sbin/install-info %{_infodir}/texinfo.gz %{_infodir}/dir || :
fi

%preun
if [ $1 = 0 ]; then
    if [ -f %{_infodir}/texinfo.gz ]; then # --excludedocs?
        /sbin/install-info --delete %{_infodir}/texinfo.gz %{_infodir}/dir || :
    fi
fi

%post -n info
if [ -f %{_infodir}/info-stnd.info ]; then # --excludedocs?
    /sbin/install-info %{_infodir}/info-stnd.info %{_infodir}/dir
fi
if [ -x /bin/sed ]; then
    /bin/sed -i '/^This is.*produced by makeinfo.*from/d' %{_infodir}/dir || :
fi

%preun -n info
if [ $1 = 0 ]; then
    if [ -f %{_infodir}/info-stnd.info ]; then # --excludedocs?
        /sbin/install-info --delete %{_infodir}/info-stnd.info %{_infodir}/dir \
        || :
    fi
fi

%post tex
%{_bindir}/texconfig-sys rehash 2> /dev/null || :

%postun tex
%{_bindir}/texconfig-sys rehash 2> /dev/null || :


%files -f %{name}.lang -f %{name}_document.lang
%doc AUTHORS ChangeLog NEWS README TODO COPYING
%{_bindir}/makeinfo
%{_bindir}/texi2any
%{_bindir}/pod2texi
%{_datadir}/texinfo
%{_infodir}/texinfo*
%{_mandir}/man1/makeinfo.1*
%{_mandir}/man5/texinfo.5*
%{_mandir}/man1/texi2any.1*
%{_mandir}/man1/pod2texi.1*

%files -n info
%config(noreplace) %verify(not md5 size mtime) %{_infodir}/dir
%doc COPYING
%{_bindir}/info
%{_bindir}/infokey
%{_infodir}/info.info*
%{_infodir}/info-stnd.info*
/sbin/install-info
%{_mandir}/man1/info.1*
%{_mandir}/man1/infokey.1*
%{_mandir}/man1/install-info.1*
%{_mandir}/man5/info.5*

%files tex
%{_bindir}/texindex
%{_bindir}/texi2dvi
%{_bindir}/texi2pdf
%{_bindir}/pdftexi2dvi
%{tex_texinfo}/
%{_mandir}/man1/texindex.1*
%{_mandir}/man1/texi2dvi.1*
%{_mandir}/man1/texi2pdf.1*
%{_mandir}/man1/pdftexi2dvi.1*

%files fivextra
%{prefix}

%changelog
* Tue Jun 04 2013 baseuser@ibm.com
- Base-8.x spec file
