# For cross, disable python unless --with python is specified.
%if 0%{?cross_build}
%bcond_with python
%else
%bcond_without python
%endif

%if 0%{?with_python}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%endif
Summary: A library for text mode user interfaces
Name: newt
Version: 0.52.15
%define base_release .3
Release: 1%{?dist}%{?base_release}
License: LGPLv2
Group: System Environment/Libraries
URL: https://fedorahosted.org/newt/
Source: https://fedorahosted.org/released/newt/newt-%{version}.tar.gz
Source999: fivextra.tar.bz2
Patch71273: bug-71273-remove-snackmodule.patch
BuildRequires: popt-devel %{?with_python:python-devel} slang-devel
%if ! 0%{?cross_build}
BuildRequires: docbook-utils
%endif
Provides: snack = %{version}-%{release}

%package devel
Summary: Newt windowing toolkit development files
Requires: slang-devel %{name}%{?_isa} = %{version}-%{release}
Group: Development/Libraries

# The loader portion of the installer needs to link statically against libnewt,
# so the static library must be shipped.
%package static
Summary: Newt windowing toolkit static library
Requires: %{name}-devel%{?_isa} = %{version}-%{release}
Group: Development/Libraries

%Description
Newt is a programming library for color text mode, widget based user
interfaces.  Newt can be used to add stacked windows, entry widgets,
checkboxes, radio buttons, labels, plain text fields, scrollbars,
etc., to text mode user interfaces.  This package also contains the
shared library needed by programs built with newt, as well as a
/usr/bin/dialog replacement called whiptail.  Newt is based on the
slang library.

%description devel
The newt-devel package contains the header files and libraries
necessary for developing applications which use newt.  Newt is a
development library for text mode user interfaces.  Newt is based on
the slang library.

Install newt-devel if you want to develop applications which will use
newt.

%description static
The newt-static package contains the static version of the newt library.
Install it if you need to link statically with libnewt.

%if 0%{?with_python}
%package python
Summary: Python bindings for newt
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}

%description python
The newt-python package contains the Python bindings for the newt library
providing a python API for creating text mode ionterfaces. 
%endif # with_python

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
 
%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch71273 -p1

%build
# gpm support seems to smash the stack w/ we use help in anaconda??
# --with-gpm-support
%configure --without-tcl
# BZ: 71273. We've removed snackmodule from the 'make all' target because
# that module requires python (which we don't have during cross). If we're
# not cross building, explicitly make that target prior to 'all'.
%if ! 0%{?cross_build}
make %{?_smp_mflags} _snackmodule.so
%endif
make %{?_smp_mflags} all
chmod 0644 peanuts.py popcorn.py
# No docbook during cross
%if ! 0%{?cross_build}
docbook2txt tutorial.sgml
%endif

%install
make DESTDIR=$RPM_BUILD_ROOT install

# Remove python scripts from buildroot if we don't have python.
%{!?with_python: rm -rf $RPM_BUILD_ROOT/%{_libdir}/python*}

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done 

install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install show* $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install test* $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install whiptail $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install popcorn.py $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests

pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
find . -type f -name '*.o' | xargs rm -f
popd

%find_lang %{name}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -f %{name}.lang
%doc COPYING
%{_bindir}/whiptail
%{_libdir}/libnewt.so.*
%{_mandir}/man1/whiptail.1*

%files devel
%doc tutorial.*
%{_includedir}/newt.h
%{_libdir}/libnewt.so
%{_libdir}/pkgconfig/libnewt.pc

%files static
%{_libdir}/libnewt.a

%if 0%{?with_python}
%files python
%doc peanuts.py popcorn.py
%{python_sitearch}/*.so
%{python_sitearch}/*.py*
%endif # with_python

%files fivextra
%{prefix}

%changelog
* Wed May 22 2013 baseuser@ibm.com
- Base-8.x spec file
