%if 0%{?fedora} && ! 0%{?base:1}
%global with_python3 1
%endif

%if 0%{?rhel} && 0%{?rhel} < 6  || 0%{?base} > 18
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%endif

%if 0%{?fedora} && 0%{?fedora} <= 16 && ! 0%{?base:1}
%{!?python3_version: %global python3_version %(%{__python3} -c 'import sys ; sys.stdout.write("%s.%s" % sys.version_info[:2])')}
%endif

Name: python-mako
Version: 0.7.3
%define base_release .2
Release: 1%{?dist}%{?base_release}
Summary: Mako template library for Python

Group: Development/Languages
# Mostly MIT, but _ast_util.py is Python licensed.
# The documentation contains javascript for search licensed BSD or GPLv2
License: (MIT and Python) and (BSD or GPLv2)
URL: http://www.makotemplates.org/
Source0: http://www.makotemplates.org/downloads/Mako-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch: noarch
BuildRequires: python2-devel
BuildRequires: python-setuptools
BuildRequires: python-markupsafe
BuildRequires: python-beaker
BuildRequires: python-nose
Requires: python-markupsafe
Requires: python-beaker

%if 0%{?with_python3}
BuildRequires: python3-devel
BuildRequires: python3-setuptools
BuildRequires: python3-markupsafe
BuildRequires: python3-beaker
%if 0%{?fedora} > 14
BuildRequires: python3-nose
%endif
BuildRequires: /usr/bin/2to3
%endif # if with_python3

%description
Mako is a template library written in Python. It provides a familiar, non-XML
syntax which compiles into Python modules for maximum performance. Mako's
syntax and API borrows from the best ideas of many others, including Django
templates, Cheetah, Myghty, and Genshi. Conceptually, Mako is an embedded
Python (i.e. Python Server Page) language, which refines the familiar ideas of
componentized layout and inheritance to produce one of the most straightforward
and flexible models available, while also maintaining close ties to Python
calling and scoping semantics.

%if 0%{?with_python3}
%package -n python3-mako
Summary: Mako template library for Python 3
Group: Development/Languages
Requires: python3-beaker
Requires: python3-markupsafe

%description -n python3-mako
Mako is a template library written in Python. It provides a familiar, non-XML
syntax which compiles into Python modules for maximum performance. Mako's
syntax and API borrows from the best ideas of many others, including Django
templates, Cheetah, Myghty, and Genshi. Conceptually, Mako is an embedded
Python (i.e. Python Server Page) language, which refines the familiar ideas of
componentized layout and inheritance to produce one of the most straightforward
and flexible models available, while also maintaining close ties to Python
calling and scoping semantics.

This package contains the mako module built for use with python3.
%endif # with_python3

%prep
%setup -q -n Mako-%{version}

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
2to3 --no-diffs -w mako test
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf %{buildroot}

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root %{buildroot}
mv %{buildroot}/%{_bindir}/mako-render %{buildroot}/%{_bindir}/python3-mako-render
popd
%endif # with_python3

%{__python} setup.py install --skip-build --root %{buildroot}

# These are supporting files for building the docs.  No need to ship
rm -rf doc/build

%check
PYTHONPATH=$(pwd) nosetests

%if 0%{?with_python3} && 0%{?fedora} > 14
pushd %{py3dir}
PYTHONPATH=$(pwd) nosetests-%{python3_version}
popd
%endif

%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root,-)
%doc CHANGES LICENSE README.rst doc examples
%{_bindir}/mako-render
%{python_sitelib}/*

%if 0%{?with_python3}
%files -n python3-mako
%defattr(-,root,root,-)
%doc CHANGES LICENSE README.rst doc examples
%{_bindir}/python3-mako-render
%{python3_sitelib}/*
%endif

%changelog
* Mon Dec 16 2013 baseuser@ibm.com
- Base-8.x spec file
