Summary:        The GNU Portable Threads library
Name:           pth
Version:        2.0.7
%define base_release .2
Release:        19%{?dist}%{?base_release}
License:        LGPLv2+
Group:          System Environment/Libraries
URL:            http://www.gnu.org/software/pth/
Source:         ftp://ftp.gnu.org/gnu/pth/pth-%{version}.tar.gz
Source1:        ftp://ftp.gnu.org/gnu/pth/pth-%{version}.tar.gz.sig
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

# Fedora customization, keep -g in the compiler options
Patch1:         pth-2.0.7-dont-remove-gcc-g.patch
# Fedora customization, fix arch-dependent conflicts in pth-config script
Patch2:         pth-2.0.7-config-script.patch
# Fedora customization, let build fail if running test_std fails
Patch3:         pth-2.0.7-test_std.patch
# bz 744740 / patch from Mikael Pettersson
Patch4: pth-2.0.7-linux3.patch

%description
Pth is a very portable POSIX/ANSI-C based library for Unix platforms
which provides non-preemptive priority-based scheduling for multiple
threads of execution ("multithreading") inside server applications.
All threads run in the same address space of the server application,
but each thread has it's own individual program-counter, run-time
stack, signal mask and errno variable.

%package devel
Summary:        Development headers and libraries for GNU Pth
Group:          Development/Libraries
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description devel
Development headers and libraries for GNU Pth.


%prep
%setup -q
%patch1 -p1 -b .dont-remove-gcc-g
%patch2 -p1 -b .config-script
%patch3 -p1 -b .test_std
%patch4 -p1 -b .no-linux3


%build
OUR_CFLAGS="${RPM_OPT_FLAGS} -D_FILE_OFFSET_BITS=64"

%ifarch %{arm}
OUR_CFLAGS=$(echo "${OUR_CFLAGS}" | sed -e 's/-Wp,-D_FORTIFY_SOURCE=2/-D_FORTIFY_SOURCE=0/g')
# guard
echo "${OUR_CFLAGS}" | grep FORTIFY_SOURCE=0
%endif

CFLAGS="${OUR_CFLAGS}"
%configure --disable-static ac_cv_func_sigstack='no'

# Work around multiarch conflicts in the pth-config script in order
# to complete patch2. Make the script choose between /usr/lib and
# /usr/lib64 at run-time.
if [ "%_libdir" == "/usr/lib64" ] ; then
    if grep -e '^pth_libdir="/usr/lib64"' pth-config ; then
        sed -i -e 's!^pth_libdir="/usr/lib64"!pth_libdir="/usr/lib"!' pth-config
    else
        echo "ERROR: Revisit the multiarch pth_libdir fixes for pth-config!"
        exit 1
    fi
fi
if [ -v OUR_CFLAGS ] && grep -e "${OUR_CFLAGS}" pth-config ; then
    # Remove our extra CFLAGS from the pth-config script, since they
    # don't belong in there.
    [ -n "${OUR_CFLAGS}" ] && sed -i -e "s!${OUR_CFLAGS}!!g" pth-config
else
    echo "ERROR: Revisit the multiarch CFLAGS fix for pth-config!"
    exit 1
fi

# this is necessary; without it make -j fails
make pth_p.h
#bug85341
%if 0%{?cross_build}
make %{?_smp_mflags} CFLAGS="${CFLAGS} -Wp,-U_FORTIFY_SOURCE -Wp,-D_FORTIFY_SOURCE=0"
%else
make %{?_smp_mflags}
%endif


%check
make test
l=$($(pwd)/pth-config --libdir)
if [ "%{_libdir}" == "/usr/lib64" ]; then
    [ "$l" == "/usr/lib64" ]
fi


%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=${RPM_BUILD_ROOT} install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la


%clean
rm -rf $RPM_BUILD_ROOT


%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%defattr(-,root,root,-)
%doc ANNOUNCE AUTHORS COPYING ChangeLog HISTORY NEWS PORTING README
%doc SUPPORT TESTS THANKS USERS
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root,-)
%doc HACKING
%{_bindir}/*
%{_includedir}/*
%{_libdir}/*.so
%{_mandir}/*/*
%{_datadir}/aclocal/*


%changelog
* Mon May 20 2013 baseuser@ibm.com
- Base-8.x spec file
