Name:           kbd
Version:        1.15.5
%define base_release .2
Release:        6%{?dist}%{?base_release}
Summary:        Tools for configuring the console (keyboard, virtual terminals, etc.)

Group:          System Environment/Base
License:        GPLv2+
URL:            http://ftp.altlinux.org/pub/people/legion/kbd
Source0:        ftp://ftp.altlinux.org/pub/people/legion/kbd/kbd-%{version}.tar.gz
Source2:        kbd-latsun-fonts.tar.bz2
Source3:        kbd-latarcyrheb-16-fixed.tar.bz2
Source4:        fr-dvorak.tar.bz2
Source5:        kbd-latarcyrheb-32.tar.bz2
Source6:        xml2lst.pl
Source7:	fivextra.tar.bz2
# Patch0: puts additional information into man pages
Patch0:         kbd-1.15-keycodes-man.patch
# Patch1: sparc modifications
Patch1:         kbd-1.15-sparc.patch
# Patch2: adds default unicode font to unicode_start script
Patch2:         kbd-1.15-unicode_start.patch
# Patch3: add missing dumpkeys option to man page
Patch3:         kbd-1.15.3-dumpkeys-man.patch
# Patch4: fixes loadkeys regression (already upstream)
Patch4:         kbd-1.15.5-loadkeys-regression.patch
# Patch5: fixes decimal separator in Swiss German keyboard layout, bz 882529
Patch5:         kbd-1.15.5-sg-decimal-separator.patch

BuildRequires:  bison, flex, gettext, pam-devel
BuildRequires:  console-setup, xkeyboard-config
Requires:       initscripts >= 5.86-1
Requires:       %{name}-misc = %{version}-%{release}
Provides:       vlock = %{version}
Conflicts:      vlock <= 1.3
Obsoletes:      vlock

%description
The %{name} package contains tools for managing a Linux
system's console's behavior, including the keyboard, the screen
fonts, the virtual terminals and font files.

%package misc
Summary:        Data for kbd package
BuildArch:      noarch
 
%description misc
The %{name}-misc package contains data for kbd package - console fonts,
keymaps etc. Please note that %{name}-misc is not helpful without kbd.

%package fivextra 
Summary: Test for %{name} package
Group: fivextra

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 2 -a 3 -a 4 -a 5 -a 7
cp -fp %{SOURCE6} .
%patch0 -p1 -b .keycodes-man
%patch1 -p1 -b .sparc
%patch2 -p1 -b .unicode_start
%patch3 -p1 -b .dumpkeys-man
%patch4 -p1 -b .loadkeys-regression
%patch5 -p1 -b .sg-decimal-separator

# 7-bit maps are obsolete; so are non-euro maps
pushd data/keymaps/i386
mv qwerty/fi.map qwerty/fi-old.map
cp qwerty/fi-latin9.map qwerty/fi.map
cp qwerty/pt-latin9.map qwerty/pt.map
cp qwerty/sv-latin1.map qwerty/se-latin1.map

mv azerty/fr.map azerty/fr-old.map
cp azerty/fr-latin9.map azerty/fr.map

cp azerty/fr-latin9.map azerty/fr-latin0.map # legacy alias

# Rename conflicting keymaps
mv dvorak/no.map dvorak/no-dvorak.map
mv fgGIod/trf.map fgGIod/trf-fgGIod.map
mv olpc/es.map olpc/es-olpc.map
mv olpc/pt.map olpc/pt-olpc.map
mv qwerty/cz.map qwerty/cz-qwerty.map
popd

# remove obsolete "gr" translation
pushd po
rm -f gr.po gr.gmo
popd

# Convert to utf-8
iconv -f iso-8859-1 -t utf-8 < "ChangeLog" > "ChangeLog_"
mv "ChangeLog_" "ChangeLog"

%build
%configure --prefix=%{_prefix} --datadir=/lib/kbd --mandir=%{_mandir} --localedir=%{_datadir}/locale --enable-nls
make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT

# ro_win.map.gz is useless
rm -f $RPM_BUILD_ROOT/lib/kbd/keymaps/i386/qwerty/ro_win.map.gz

# Create additional name for Serbian latin keyboard
ln -s sr-cy.map.gz $RPM_BUILD_ROOT/lib/kbd/keymaps/i386/qwerty/sr-latin.map.gz

# The rhpl keyboard layout table is indexed by kbd layout names, so we need a
# Korean keyboard
ln -s us.map.gz $RPM_BUILD_ROOT/lib/kbd/keymaps/i386/qwerty/ko.map.gz

# Move binaries which we use before /usr is mounted from %{_bindir} to /bin.
mkdir -p $RPM_BUILD_ROOT/bin
for binary in setfont dumpkeys kbd_mode unicode_start unicode_stop loadkeys ; do
  mv $RPM_BUILD_ROOT%{_bindir}/$binary $RPM_BUILD_ROOT/bin/
done

# Some microoptimization
sed -i -e 's,\<kbd_mode\>,/bin/kbd_mode,g;s,\<setfont\>,/bin/setfont,g' \
        $RPM_BUILD_ROOT/bin/unicode_start

# Link open to openvt
ln -s openvt $RPM_BUILD_ROOT%{_bindir}/open

# Move locale files to correct place
cp -r $RPM_BUILD_ROOT/lib/kbd/locale/ $RPM_BUILD_ROOT%{_datadir}/locale
rm -rf $RPM_BUILD_ROOT/lib/kbd/locale

# Convert X keyboard layouts to console keymaps
mkdir -p $RPM_BUILD_ROOT/lib/kbd/keymaps/xkb
perl xml2lst.pl < /usr/share/X11/xkb/rules/base.xml > layouts-variants.lst
while read line; do
  XKBLAYOUT=`echo "$line" | cut -d " " -f 1`
  XKBVARIANT=`echo "$line" | cut -d " " -f 2`
  ckbcomp "$XKBLAYOUT" "$XKBVARIANT" | gzip > $RPM_BUILD_ROOT/lib/kbd/keymaps/xkb/"$XKBLAYOUT"-"$XKBVARIANT".map.gz
done < layouts-variants.lst

%find_lang %{name}

# Steps to package the kbd tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

%files -f %{name}.lang
%doc ChangeLog AUTHORS README COPYING doc/kbd.FAQ*.html doc/font-formats/*.html doc/utf/utf* doc/dvorak/*
/bin/*
%{_bindir}/*
%{_mandir}/*/*

%files misc
/lib/kbd

%files fivextra
%{fivdir}

%changelog
* Mon Jul 08 2013 baseuser@ibm.com
- Base-8.x spec file
