
%if ( ! (0%{?fedora} > 12 || 0%{?rhel} > 5) ) ||  0%{?base:1}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif


Name:           openwsman
BuildRequires:  swig
BuildRequires:  libcurl-devel libxml2-devel pam-devel sblim-sfcc-devel
BuildRequires:  python python-devel ruby ruby-devel rubygem(rdoc) perl
BuildRequires:  python python-devel perl
BuildRequires:  perl-devel pkgconfig openssl-devel
#BuildRequires:	java-1.8.0-openjdk-devel
BuildRequires:  cmake
BuildRequires:  systemd-units
Version:        2.3.6
%define base_release .2
Release:        6%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Url:            http://www.openwsman.org/
License:        BSD
Group:          Applications/System
Summary:        Open source Implementation of WS-Management
Source:         http://downloads.sourceforge.net/project/openwsman/%{name}/%{version}/%{name}-%{version}.tar.bz2
# help2man generated manpage for openwsmand binary
Source1:        openwsmand.8.gz
# service file for systemd
Source2:        openwsmand.service
# script for testing presence of the certificates in ExecStartPre
Source3:        owsmantestcert.sh
Patch1:         openwsman-2.2.7-libssl.patch

%description
Openwsman is a project intended to provide an open-source
implementation of the Web Services Management specipication
(WS-Management) and to expose system management information on the
Linux operating system using the WS-Management protocol. WS-Management
is based on a suite of web services specifications and usage
requirements that exposes a set of operations focused on and covers
all system management aspects.




%package -n libwsman1
License:        BSD
Group:          System Environment/Libraries
Summary:        Open source Implementation of WS-Management
Provides:       %{name} = %{version}
Obsoletes:      %{name} < %{version}

%description -n libwsman1
Openwsman library for packages dependent on openwsman




%package -n libwsman-devel
License:        BSD
Group:          Development/Libraries
Summary:        Open source Implementation of WS-Management
Provides:       %{name}-devel = %{version}
Obsoletes:      %{name}-devel < %{version}
Requires:       libwsman1 = %{version}
Requires:       %{name}-server = %{version}
Requires:       %{name}-client = %{version}
Requires:       sblim-sfcc-devel libxml2-devel pam-devel
Requires:       libcurl-devel

%description -n libwsman-devel
Development files for openwsman



%package client
License:        BSD
Group:          System Environment/Libraries
Summary:        Openwsman Client libraries

%description client
Openwsman Client libraries




%package server
License:        BSD
Group:          System Environment/Daemons
Requires:       net-tools
Requires(post):       chkconfig
Requires(preun):      chkconfig
Requires(postun):     initscripts
Summary:        Openwsman Server and service libraries

%description server
Openwsman Server and service libraries




%package python
License:        BSD
Group:          Development/Libraries
Summary:        Python bindings for openwsman client API
Requires:       python

%description python
This package provides Python bindings to access the openwsman client
API.




%package ruby
License:        BSD
Group:          Development/Libraries
Requires:       ruby
Requires:       ruby(release)
Summary:        Ruby bindings for openwsman client API

%description ruby
This package provides Ruby bindings to access the openwsman client API.

#%package java
#Requires: 	java
#Requires: 	libwsman1 = %{version}
#Summary: 	Java bindings for openwsman client API
#Group:          Development/Libraries

#%description java
#This package provides Java bindings to access the openwsman client API.


%package perl
License:        BSD
Group:          Development/Libraries
Requires:       perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))
Summary:        Perl bindings for openwsman client API

%description perl
This package provides Perl bindings to access the openwsman client API.




%prep
%setup -q
%patch1 -p1 -b .libssl

%build
# Removing executable permissions on .c and .h files to fix rpmlint warnings. 
chmod -x src/cpp/WsmanClient.h

rm -rf build
mkdir build

export RPM_OPT_FLAGS="$RPM_OPT_FLAGS -DFEDORA -DNO_SSL_CALLBACK"
export SSL_LIB=`readlink %{_libdir}/libssl.so`
cd build
cmake \
  -DCMAKE_INSTALL_PREFIX=/usr \
  -DCMAKE_VERBOSE_MAKEFILE=TRUE \
  -DCMAKE_BUILD_TYPE=Release \
  -DCMAKE_C_FLAGS_RELEASE:STRING="$RPM_OPT_FLAGS -fno-strict-aliasing" \
  -DCMAKE_CXX_FLAGS_RELEASE:STRING="$RPM_OPT_FLAGS" \
  -DCMAKE_SKIP_RPATH=1 \
  -DPACKAGE_ARCHITECTURE=`uname -m` \
  -DLIB=%{_lib} \
  -DBUILD_RUBY_GEM=no \
   ..

make CFLAGS="-DSSL_LIB='\"$SSL_LIB\"'"

%install
cd build
make DESTDIR=%{buildroot} install
cd ..
rm -f %{buildroot}/%{_libdir}/*.la
rm -f %{buildroot}/%{_libdir}/openwsman/plugins/*.la
rm -f %{buildroot}/%{_libdir}/openwsman/authenticators/*.la
[ -d %{buildroot}/%{ruby_vendorlibdir} ] && rm -f %{buildroot}/%{ruby_vendorlibdir}/openwsmanplugin.rb
[ -d %{buildroot}/%{ruby_vendorlibdir} ] && rm -f %{buildroot}/%{ruby_vendorlibdir}/openwsman.rb
mkdir -p %{buildroot}%{_sysconfdir}/init.d
install -m 644 etc/openwsman.conf %{buildroot}/%{_sysconfdir}/openwsman
install -m 644 etc/openwsman_client.conf %{buildroot}/%{_sysconfdir}/openwsman
mkdir -p %{buildroot}/%{_unitdir}
install -p -m 644 %{SOURCE2} %{buildroot}/%{_unitdir}/openwsmand.service
install -m 644 etc/ssleay.cnf %{buildroot}/%{_sysconfdir}/openwsman
install -p -m 755 %{SOURCE3} %{buildroot}/%{_sysconfdir}/openwsman
# install manpage
mkdir -p %{buildroot}/%{_mandir}/man8/
cp %SOURCE1 %{buildroot}/%{_mandir}/man8/
# install missing headers
install -m 644 include/wsman-xml.h %{buildroot}/%{_includedir}/openwsman
install -m 644 include/wsman-xml-binding.h %{buildroot}/%{_includedir}/openwsman
install -m 644 include/wsman-dispatcher.h %{buildroot}/%{_includedir}/openwsman

%post -n libwsman1 -p /sbin/ldconfig

%postun -n libwsman1 -p /sbin/ldconfig

%post server
/sbin/ldconfig
%systemd_post openwsmand.service

%preun server
%systemd_preun openwsmand.service

%postun server
rm -f /var/log/wsmand.log
%systemd_postun_with_restart openwsmand.service
/sbin/ldconfig

%post client -p /sbin/ldconfig

%postun client -p /sbin/ldconfig

%files -n libwsman1
%doc AUTHORS COPYING ChangeLog README.md TODO
%{_libdir}/libwsman.so.*
%{_libdir}/libwsman_client.so.*
%{_libdir}/libwsman_curl_client_transport.so.*

%files -n libwsman-devel
%{_includedir}/*
%{_libdir}/pkgconfig/*
%{_libdir}/*.so
%doc AUTHORS COPYING ChangeLog README.md

%files python
%{python_sitearch}/*.so
%{python_sitearch}/*.py
%{python_sitearch}/*.pyc
%{python_sitearch}/*.pyo
%doc AUTHORS COPYING ChangeLog README.md

%files ruby
%{ruby_vendorarchdir}/_openwsman.so
%dir %{ruby_vendorlibdir}/openwsman
%{ruby_vendorlibdir}/openwsman/*.rb
%doc AUTHORS COPYING ChangeLog README.md


#%files java
#%defattr(-,root,root)
#%{_javadir}/*jar

%files perl
%{perl_vendorarch}/openwsman.so
%{perl_vendorlib}/openwsman.pm
%doc AUTHORS COPYING ChangeLog README.md

%files server
# Don't remove *.so files from the server package.
# the server fails to start without these files.
%dir %{_sysconfdir}/openwsman
%config(noreplace) %{_sysconfdir}/openwsman/openwsman.conf
%config(noreplace) %{_sysconfdir}/openwsman/ssleay.cnf
%attr(0755,root,root) %{_sysconfdir}/openwsman/owsmangencert.sh
%attr(0755,root,root) %{_sysconfdir}/openwsman/owsmantestcert.sh
%config(noreplace) %{_sysconfdir}/pam.d/openwsman
%{_unitdir}/openwsmand.service
%dir %{_libdir}/openwsman
%dir %{_libdir}/openwsman/authenticators
%{_libdir}/openwsman/authenticators/*.so
%{_libdir}/openwsman/authenticators/*.so.*
%dir %{_libdir}/openwsman/plugins
%{_libdir}/openwsman/plugins/*.so
%{_libdir}/openwsman/plugins/*.so.*
%{_sbindir}/openwsmand
%{_libdir}/libwsman_server.so.*
%{_mandir}/man8/*
%doc AUTHORS COPYING ChangeLog README.md

%files client
%{_libdir}/libwsman_clientpp.so.*
%config(noreplace) %{_sysconfdir}/openwsman/openwsman_client.conf
%doc AUTHORS COPYING ChangeLog README.md


%changelog
* Mon Jul 01 2013 baseuser@ibm.com
- Base-8.x spec file
