# For cross, disable python unless --with python is specified.
%if 0%{?cross_build}
%bcond_with python
%else
%bcond_without python
%endif

Summary: Library providing the FAM File Alteration Monitor API
Name: gamin
Version: 0.1.10
%define base_release .3
Release: 14%{?dist}%{?base_release}
License: LGPLv2
#some of the files (server/inotify-kernel.c) are GPLv2
#so https://fedoraproject.org/wiki/Licensing#GPL_Compatibility_Matrix
#says the whole is GPLv2
#License: GPLv2
Group: Development/Libraries
Source: http://ftp.gnome.org/pub/GNOME/sources/gamin/0.1/gamin-%{version}.tar.bz2
Source999: fivextra.tar.bz2 
URL: http://www.gnome.org/~veillard/gamin/
Obsoletes: fam < 2.6.10-12
Provides: fam = 2.6.10-12
#BuildRequires: glib2-devel python python-devel
BuildRequires: glib2-devel 
BuildRequires: automake, libtool
%{?with_python:BuildRequires: python-devel}

# This fix addresses an issue with ARM, where the configuration triplet
# happens to be armv5tel-redhat-linux-gnueabi instead of armv5tel-redhat-linux-gnu.
# The patch declares HAVE_LINUX in case of linux-gnueabi as well.
# Patch by Kedar Sovani <kedars@marvell.com>
Patch1: gamin-0.1.10-gnueabi.patch

# Don't try to build with -DG_DISABLE_DEPRECATED - glib has moved on
Patch2: gamin-manape.patch

# gam_server deadlocks, leading to all KDE applications hanging at start
# https://bugzilla.redhat.com/show_bug.cgi?id=786170
Patch3: gamin-0.1.11-double-lock.patch

# upstream fixes
Patch4: 0001-Poll-files-on-nfs4.patch
Patch5: 0002-Fix-compilation-of-recent-glib-removing-G_CONST_RETU.patch

# base patches
Patch70275: bug70275-crossbuild-abstract-namespace.diff
Patch84353: gamin-0.1.10-84353.patch

%description
This C library provides an API and ABI compatible file alteration
monitor mechanism compatible with FAM but not dependent on a system wide
daemon.

%package devel
Summary: Libraries, includes, etc. to embed the Gamin library
Group: Development/Libraries
Requires: gamin = %{version}-%{release}
Obsoletes: fam-devel < 2.6.10-12
Provides: fam-devel = 2.6.10-12

%description devel
This C library provides an API and ABI compatible file alteration
monitor mechanism compatible with FAM but not dependent on a system wide
daemon.

%if 0%{?with_python}
%package python
Summary: Python bindings for the gamin library
Group: Development/Libraries
Requires: gamin = %{version}-%{release}

%description python
The gamin-python package contains a module that allow monitoring of
files and directories from the Python language based on the support
of the gamin package.
%endif # end with python

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch1 -p1 -b .gnueabi
%patch2 -p1 -b .manape
%patch3 -p1 -b .double-lock
%patch4 -p1 -b .nfs4
%patch5 -p1 -b .const

%patch70275 -p1
%patch84353 -p1
# recode docs into UTF-8
for i in ChangeLog NEWS ; do 
   iconv -f iso-8859-1 -t utf-8 < $i > XXX
   touch -r $i XXX
   mv XXX $i
done

# https://fedoraproject.org/wiki/Features/SystemPythonExecutablesUseSystemPython
# replace "/usr/bin/env python" with a "/usr/bin/python"
for i in `find -name '*.py'`; do
   sed -i.bak 's|^#!/usr/bin/env python|#!/usr/bin/python|g' $i
   touch -r ${i}.bak $i
   rm ${i}.bak
done

autoreconf --force --install

%build
%configure
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot} INSTALL="install -p"
find $RPM_BUILD_ROOT -name '*.la' -or -name '*.a' | xargs rm -f

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in $(find tests -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir || true
  rm -rf $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir/testing.o
  rm -rf $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir/testgam
  install  $dir/.libs/testgam  $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir || true
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 


%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc AUTHORS ChangeLog NEWS README Copyright TODO COPYING
%doc doc/*.html
%doc doc/*.gif
%doc doc/*.txt
%{_libdir}/lib*.so.*
%{_libexecdir}/gam_server

%files devel
%{_libdir}/lib*.so
%{_includedir}/fam.h
%{_libdir}/pkgconfig/gamin.pc

%if 0%{?with_python}
%files python
%{_libdir}/python*/site-packages/gamin.py*
%{_libdir}/python*/site-packages/_gamin*
%doc python/tests/*.py
%doc doc/python.html
%endif

%files fivextra
%{prefix} 

%changelog
* Thu May 16 2013 baseuser@ibm.com
- Base-8.x spec file
