# Expected failures in mock, hangs in koji
%bcond_with tests
# The *.py files we ship are not python scripts, #813651
%global _python_bytecompile_errors_terminate_build 0

Name:           bash-completion
Version:        2.1
%define base_release .3
Release:        2%{?dist}%{?base_release}
Epoch:          1
Summary:        Programmable completion for Bash

License:        GPLv2+
URL:            http://bash-completion.alioth.debian.org/
Source0:        http://bash-completion.alioth.debian.org/files/%{name}-%{version}.tar.bz2
Source2:        CHANGES.package.old
# https://bugzilla.redhat.com/677446, see also noblacklist patch
Source3:        %{name}-2.0-redefine_filedir.bash
# https://bugzilla.redhat.com/677446, see also redefine_filedir source
Patch0:         %{name}-1.99-noblacklist.patch
# Commands included in util-linux >= 2.23-rc2
Patch1:         %{name}-2.1-util-linux-223.patch

BuildArch:      noarch
%if %{with tests}
BuildRequires:  dejagnu
BuildRequires:  screen
BuildRequires:  tcllib
%endif
Requires:       bash >= 4.1

%description
bash-completion is a collection of shell functions that take advantage
of the programmable completion feature of bash.


%prep
%setup -q
%patch0 -p1
%if 0%{?fedora} >= 19
%patch1 -p1
%endif
install -pm 644 %{SOURCE2} .


%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=$RPM_BUILD_ROOT

# Updated completion shipped in cowsay package:
rm $RPM_BUILD_ROOT%{_datadir}/bash-completion/completions/{cowsay,cowthink}
%if 0%{?fedora} < 0%{?fedora:19}
# systemd >= 198 ships this one:
install -pm 644 completions/_udevadm \
    $RPM_BUILD_ROOT%{_datadir}/bash-completion/completions/udevadm
%endif
%if 0%{?fedora} > 17
# NetworkManager >= 0.9.8.0 ships this one:
rm $RPM_BUILD_ROOT%{_datadir}/bash-completion/completions/nmcli
%endif

install -Dpm 644 %{SOURCE3} \
    $RPM_BUILD_ROOT%{_sysconfdir}/bash_completion.d/redefine_filedir


%if %{with tests}
%check
# For some tests involving non-ASCII filenames
export LANG=en_US.UTF-8
# This stuff borrowed from dejagnu-1.4.4-17 (tests need a terminal)
tmpfile=$(mktemp)
screen -D -m sh -c '( make check ; echo $? ) >'$tmpfile
cat $tmpfile
result=$(tail -n 1 $tmpfile)
rm -f $tmpfile
exit $result
%endif


%files
%doc AUTHORS CHANGES CHANGES.package.old COPYING README
# Temporarily not noreplace for < 1.90 to 1.90+ updates (changed location)
%config %{_sysconfdir}/profile.d/bash_completion.sh
%{_sysconfdir}/bash_completion.d/
%{_datadir}/bash-completion/
%{_datadir}/pkgconfig/bash-completion.pc


%changelog
* Mon Jul 08 2013 baseuser@ibm.com
- Base-8.x spec file
