%global tarball libXi
%global gitdate 20130524
%global gitversion 661c45ca1

Summary: X.Org X11 libXi runtime library
Name: libXi
Version: 1.7.1
%define base_release .2
Release: 5%{?gitdate:.%{gitdate}git%{gitversion}}%{dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: MIT
Group: System Environment/Libraries
URL: http://www.x.org

%if 0%{?gitdate}
Source0:    %{tarball}-%{gitdate}.tar.bz2
Source1:    make-git-snapshot.sh
%else
Source0: ftp://ftp.x.org/pub/individual/lib/%{name}-%{version}.tar.bz2
%endif

BuildRequires: autoconf automake libtool
BuildRequires: xorg-x11-util-macros
BuildRequires: xorg-x11-proto-devel
BuildRequires: pkgconfig(inputproto) >= 2.2.99.1
BuildRequires: libX11-devel >= 1.5.99.902
BuildRequires: libXext-devel libXfixes-devel
BuildRequires: xmlto asciidoc >= 8.4.5

Requires: libX11 >= 1.5.99.902

%description
X.Org X11 libXi runtime library

%package devel
Summary: X.Org X11 libXi development package
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
# required by xi.pc
Requires: xorg-x11-proto-devel
Requires: pkgconfig

%description devel
X.Org X11 libXi development package

%prep
%setup -q -n %{tarball}-%{?gitdate:%{gitdate}}%{!?gitdate:%{version}}

# Disable static library creation by default.
%define with_static 0

%build
autoreconf -v --install || exit 1
%configure --disable-specs \
%if ! %{with_static}
	--disable-static
%endif

make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT

# We intentionally don't ship *.la files
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING
%{_libdir}/libXi.so.6
%{_libdir}/libXi.so.6.1.0

%files devel
%defattr(-,root,root,-)
%if %{with_static}
%{_libdir}/libXi.a
%endif
%{_includedir}/X11/extensions/XInput.h
%{_includedir}/X11/extensions/XInput2.h
%{_libdir}/libXi.so
%{_libdir}/pkgconfig/xi.pc
#%dir %{_mandir}/man3x
%{_mandir}/man3/*.3*

%changelog
* Mon Jul 08 2013 baseuser@ibm.com
- Base-8.x spec file
