Summary: File system tree viewer
Name: tree
Version: 1.6.0
%define base_release .1
Release: 11%{?dist}%{?base_release}
Group: Applications/File
License: GPLv2+
Url: http://mama.indstate.edu/users/ice/tree/
Source: ftp://mama.indstate.edu/linux/tree/tree-%{version}.tgz
Patch1: tree-no-strip.patch
Patch2: tree-preserve-timestamps.patch
Patch3: tree-no-color-by-default.patch
Patch4: tree-args.patch
Patch5: tree-fixbufsiz.patch
Patch6: tree-dircolors-ec.patch
Patch7: tree-size-field-len.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
The tree utility recursively displays the contents of directories in a
tree-like format.  Tree is basically a UNIX port of the DOS tree
utility.

%prep
%setup -q
# Don't strip binary in the Makefile -- let rpmbuild do it.
%patch1 -p1 -b .no-strip

# Preserve timestamp on man page.
%patch2 -p1 -b .preserve-timestamps

# Disable color output by default.
%patch3 -p1 -b .no-color-by-default

# Document --du and --prune options in help output (bug #948991).
%patch4 -p1 -b .args

# Handle large UID/GID values (bug #980945).
%patch5 -p1 -b .fixbufsiz

# Use correct default for dircolors "ec" field (bug #812934).
%patch6 -p1 -b .dircolors-ec

# Keep file size field length constant regardless of whether SI units
# are used (bug #997937).
%patch7 -p1 -b .size-field-len

%build
make CFLAGS="$RPM_OPT_FLAGS $(getconf LFS_CFLAGS)" %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}

make	BINDIR=$RPM_BUILD_ROOT%{_bindir} \
	MANDIR=$RPM_BUILD_ROOT%{_mandir}/man1 \
	install

chmod -x $RPM_BUILD_ROOT%{_mandir}/man1/tree.1

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/tree
%{_mandir}/man1/tree.1*
%doc README LICENSE

%changelog
* Tue Jul 15 2014 baseuser@ibm.com
- Base-f19.x spec file
