%global ebminor 4

Name:			ebtables
Version:		2.0.10
%define base_release .2
Release:		8%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:		Ethernet Bridge frame table administration tool
License:		GPLv2+
Group:			System Environment/Base
URL:			http://ebtables.sourceforge.net/
Source0:		http://downloads.sourceforge.net/ebtables/ebtables-v%{version}-%{ebminor}.tar.gz
Source1:		ebtables-save
Source999: fivextra.tar.bz2 
Requires(pre):		/sbin/chkconfig
Requires(postun):	/sbin/service
Patch0:			ebtables-2.0.10-norootinst.patch
Patch3:			ebtables-2.0.9-lsb.patch
Patch4:			ebtables-2.0.10-linkfix.patch
Patch5:			ebtables-2.0.0-audit.patch

%description
Ethernet bridge tables is a firewalling tool to transparently filter network
traffic passing a bridge. The filtering possibilities are limited to link
layer filtering and some basic filtering on higher network layers.

This tool is the userspace control for the bridge and ebtables kernel
components (built by default in Fedora kernels).

The ebtables tool can be used together with the other Linux filtering tools,
like iptables. There are no known incompatibility issues.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n ebtables-v%{version}-%{ebminor} -a 999
%patch0 -p1 -b .norootinst
%patch3 -p1 -b .lsb
# extension modules need to link to libebtc.so for ebt_errormsg
%patch4 -p1 -b .linkfix
%patch5 -p1 -b .AUDIT

# Convert to UTF-8
f=THANKS; iconv -f iso-8859-1 -t utf-8 $f -o $f.utf8 ; mv $f.utf8 $f

%build
MY_CFLAGS=`echo $RPM_OPT_FLAGS -fPIC | sed -e 's/-fstack-protector//g'`
make %{?_smp_mflags} CFLAGS="$MY_CFLAGS" LIBDIR="/%{_lib}/ebtables" BINDIR="/sbin" MANDIR="%{_mandir}"

%install
mkdir -p $RPM_BUILD_ROOT%{_initrddir}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
make DESTDIR="$RPM_BUILD_ROOT" LIBDIR="/%{_lib}/ebtables" BINDIR="/sbin" MANDIR="%{_mandir}" install
touch $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/ebtables.filter
touch $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/ebtables.nat
touch $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/ebtables.broute

# install ebtables-save bash script
rm -f $RPM_BUILD_ROOT/sbin/ebtables-save
install %{SOURCE1} $RPM_BUILD_ROOT/sbin/ebtables-save

# move libebtc.so into the ldpath
mv %{buildroot}/%{_lib}/ebtables/libebtc.so %{buildroot}/%{_lib}/

# Steps to package the ebtables tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
/sbin/chkconfig --add ebtables
/sbin/ldconfig

%preun
if [ $1 -eq 0 ]; then
	/sbin/service ebtables stop &>/dev/null || :
	/sbin/chkconfig --del ebtables
fi

%postun
if [ $1 -ge 1 ]; then
	/sbin/service ebtables condrestart &> /dev/null || :
fi
/sbin/ldconfig

%files
%defattr(-, root, root, 0755)
%doc ChangeLog COPYING THANKS
%doc %{_mandir}/man8/ebtables.8*
%config(noreplace) %{_sysconfdir}/ethertypes
%config(noreplace) %{_sysconfdir}/sysconfig/ebtables-config
%{_initrddir}/ebtables
/%{_lib}/libebtc.so
/%{_lib}/ebtables/
/sbin/ebtables*
%ghost %{_sysconfdir}/sysconfig/ebtables.filter
%ghost %{_sysconfdir}/sysconfig/ebtables.nat
%ghost %{_sysconfdir}/sysconfig/ebtables.broute

%files fivextra
%{prefix}

%changelog
* Tue Jun 04 2013 baseuser@ibm.com
- Base-8.x spec file
