Summary: Event expression library inspired by CEE
Name: libee
Version: 0.4.1
%define base_release .3
Release: 4%{?dist}%{?base_release}
ExcludeArch: mips64 ppca2 
License: LGPLv2+ and MIT and GPL+ 
Group: System Environment/Libraries 
URL: http://www.libee.org
Source0: http://www.libee.org/files/download/%{name}-%{version}.tar.gz

BuildRequires: libestr-devel
BuildRequires: chrpath

%description
The core idea of libee is to provide a small but hopefully convenient API layer
above the CEE standard. CEE is under heavy development and even some of its 
core data structures have not been fully specified.

CEE is an upcoming standard used to describe network events in a number of
normalized formats. It's goal is to unify many different
representations that exist in the industry.

%package devel
Summary: Development files for libee
Group: Development/Libraries
Requires:   %{name}%{?_isa} = %{version}-%{release}
Requires: libestr-devel%{?_isa}

%package utils
Summary:   Optional utilities like libee-convert 
Requires:   %{name}%{?_isa} = %{version}-%{release}

%description devel
This package provides files required for development with libee,
the event expression library used by the rsyslog daemon.

%description utils
The libee-convert utility provided by event expression library.

%prep
%setup -q  -n %{name}-%{version}

%build
%configure 
V=1 make

%install
make install INSTALL="install -p" DESTDIR=%{buildroot}
rm -f %{buildroot}/%{_libdir}/*.{a,la}

# chrpath can't be run against non-native executables.
%{!?cross_build:chrpath --delete %{buildroot}%{_libdir}/libee.so.*}
%{!?cross_build:chrpath --delete %{buildroot}%{_sbindir}/libee-convert}

%check
make check

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc README COPYING AUTHORS ChangeLog
%{_libdir}/libee.so.0
%{_libdir}/libee.so.0.0.0

%files devel
%{_libdir}/pkgconfig/libee.pc
%dir %{_includedir}/libee
%{_includedir}/libee/*.h
%{_libdir}/*.so

%files utils
%{_sbindir}/*

%changelog
* Thu Jun 13 2013 baseuser@ibm.com
- Base-8.x spec file
