# We need to regenerate the HMAC values after the buildroot policies have
# mucked around with binaries.  This overrides the default which was in place
# at least from Red Hat Linux 9 through Fedora 11's development cycle.
%define __spec_install_post \
	%{?__debug_package:%{__debug_install_post}} \
	%{__arch_install_post} \
	%{__os_install_post} \
	for length in 1 256 384 512 ; do \
		$RPM_BUILD_ROOT/%{_bindir}/sha${length}hmac -S > \\\
		$RPM_BUILD_ROOT/%{_libdir}/%{name}/sha${length}hmac.hmac \
	done \
       %{?__base_source:%{base_install_post}} \
	%{nil}

Name:		hmaccalc
Version:	0.9.12
%define base_release .4
Release:	5%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:	Tools for computing and checking HMAC values for files

Group:		System Environment/Base
License:	MIT
URL:		https://fedorahosted.org/hmaccalc/
Source0:	https://fedorahosted.org/released/hmaccalc/hmaccalc-%{version}.tar.gz
Source999:	fivextra.tar.bz2
BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

BuildRequires:	nss-devel, prelink

%description
The hmaccalc package contains tools which can calculate HMAC (hash-based
message authentication code) values for files.  The names and interfaces are
meant to mimic the sha*sum tools provided by the coreutils package.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: prelink

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%build
%configure --enable-sum-directory=%{_libdir}/%{name}
make %{?_smp_mflags}

make check || true

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in $(find test -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name}/test -name '*.o' -o -name '*.c' -o -name 'Makefile*' -o -name 'sha*hmac' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%check
make check

%files
%defattr(-,root,root,-)
%doc README LICENSE
%{_bindir}/sha1hmac
%{_bindir}/sha256hmac
%{_bindir}/sha384hmac
%{_bindir}/sha512hmac
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/sha1hmac.hmac
%{_libdir}/%{name}/sha256hmac.hmac
%{_libdir}/%{name}/sha384hmac.hmac
%{_libdir}/%{name}/sha512hmac.hmac
%{_mandir}/*/*

%files fivextra
%{prefix}

%changelog
* Tue Jun 04 2013 baseuser@ibm.com
- Base-8.x spec file
