Summary: The GNU versions of find utilities (find and xargs)
Name: findutils
Version: 4.5.11
%define base_release .3
Release: 1%{?dist}%{?base_release}
Epoch: 1
License: GPLv3+
Group: Applications/File
URL: http://www.gnu.org/software/findutils/
Source0: ftp://alpha.gnu.org/gnu/findutils/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2

# do not build locate
Patch1: findutils-4.4.0-no-locate.patch

# learn find to recognize autofs file system by reading /proc/mounts
# as autofs mount points are not listed in /etc/mtab
Patch2: findutils-4.4.2-autofs.patch

# add a new option -xautofs to find to not descend into directories on autofs
# file systems
Patch3: findutils-4.4.2-xautofs.patch

# eliminate compile-time warnings
Patch4: findutils-4.5.7-warnings.patch

Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Conflicts: filesystem < 3
Provides: /bin/find
Provides: bundled(gnulib)

Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: automake
BuildRequires: dejagnu
BuildRequires: gettext-devel
BuildRequires: libselinux-devel
BuildRequires: texinfo

%description
The findutils package contains programs which will help you locate
files on your system.  The find utility searches through a hierarchy
of directories looking for files which match a certain set of criteria
(such as a file name pattern).  The xargs utility builds and executes
command lines from standard input arguments (usually lists of file
names generated by the find command).

You should install findutils because it includes tools that are very
useful for finding things on your system.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -a 999
rm -rf locate
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

# needed because of findutils-4.4.0-no-locate.patch
autoreconf -iv

%build
%configure

# uncomment to turn off optimizations
#find -name Makefile | xargs sed -i 's/-O2/-O0/'

make %{?_smp_mflags}

pushd fivextra
make all
popd

%check
make check

%install
make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%{_infodir}/dir

%find_lang %{name}

# Steps to package the findutils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
if [ -f %{_infodir}/find.info.gz ]; then
  /sbin/install-info %{_infodir}/find.info.gz %{_infodir}/dir || :
fi

%preun
if [ $1 = 0 ]; then
  if [ -f %{_infodir}/find.info.gz ]; then
    /sbin/install-info --delete %{_infodir}/find.info.gz %{_infodir}/dir || :
  fi
fi

%files -f %{name}.lang
%doc AUTHORS COPYING NEWS README THANKS TODO ChangeLog
%{_bindir}/find
%{_bindir}/oldfind
%{_bindir}/xargs
%{_mandir}/man1/find.1*
%{_mandir}/man1/oldfind.1*
%{_mandir}/man1/xargs.1*
%{_infodir}/find.info*
%{_infodir}/find-maint.info.gz

%files fivextra
%{prefix}

%changelog
* Fri May 03 2013 baseuser@ibm.com
- Base-8.x spec file
