Summary: GNU's bc (a numeric processing language) and dc (a calculator)
Name: bc
Version: 1.06.95
%define base_release .2
Release: 9%{?dist}%{?base_release}
License: GPLv2+
URL: http://www.gnu.org/software/bc/
Group: Applications/Engineering
Source: ftp://alpha.gnu.org/pub/gnu/bc/bc-%{version}.tar.bz2
Source999: fivextra.tar.bz2
Patch1: bc-1.06-dc_ibase.patch
Patch2: bc-1.06.95-memleak.patch
Patch3: bc-1.06.95-matlib.patch
Patch4: bc-1.06.95-sigintmasking.patch
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: readline-devel, flex, bison, texinfo

%description
The bc package includes bc and dc. Bc is an arbitrary precision
numeric processing arithmetic language. Dc is an interactive
arbitrary precision stack based calculator, which can be used as a
text mode calculator.

Install the bc package if you need its number handling capabilities or
if you would like to use its text mode calculator.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
%patch1 -p1 -b .dc_ibase
%patch2 -p1 -b .memleak
%patch3 -p1 -b .matlib
%patch4 -p1 -b .sigintmask

%build
%configure --with-readline
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT/%{_infodir}/dir

# Steps to package the bc tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
if [ -e %{_infodir}/bc.info.gz -a -e %{_infodir}/dc.info.gz ]; then
  /sbin/install-info %{_infodir}/bc.info.gz %{_infodir}/dir \
  --entry="* bc: (bc).                      The GNU calculator language." || :
  /sbin/install-info %{_infodir}/dc.info.gz %{_infodir}/dir \
  --entry="* dc: (dc).                      The GNU RPN calculator." || :
fi

%preun
if [ $1 = 0 -a -e %{_infodir}/bc.info.gz -a -e %{_infodir}/dc.info.gz ]; then
  /sbin/install-info --delete %{_infodir}/bc.info.gz %{_infodir}/dir \
  --entry="* bc: (bc).                      The GNU calculator language." || :
  /sbin/install-info --delete %{_infodir}/dc.info.gz %{_infodir}/dir \
  --entry="* dc: (dc).                      The GNU RPN calculator." || :
fi

%files
%defattr(-,root,root,-)
%doc COPYING COPYING.LIB FAQ AUTHORS NEWS README Examples/
%{_bindir}/dc
%{_bindir}/bc
%{_mandir}/*/*
%{_infodir}/*

%files fivextra
%{prefix}

%changelog
* Thu May 30 2013 baseuser@ibm.com
- Base-8.x spec file
