Name:		ethtool
Epoch:		2
Version:	3.8
%define base_release .2
Release:	1%{?dist}%{?base_release}
Summary:	Settings tool for Ethernet NICs

License:	GPLv2
Group:		Applications/System
#Old URL:	http://sourceforge.net/projects/gkernel/
URL:		http://ftp.kernel.org/pub/software/network/%{name}/

# When using tarball from released upstream version:
# - http://ftp.kernel.org/pub/software/network/%{name}/%{name}-%{version}.tar.bz2
#
# When generating tarball package from upstream git:
# - git clone git://git.kernel.org/pub/scm/network/ethtool/ethtool.git ethtool-6
# - cd ethtool-6; git checkout 669ba5cadfb15842e90d8aa7ba5a575f7a457b3e
# - cp -f ChangeLog ChangeLog.old; git log > ChangeLog.git
# - rm -rf .git; cd ..; tar cvfz ethtool-6.tar.gz ethtool-6
# - Use the visible date of latest git log entry for %{release} in spec file
Source0:	http://ftp.kernel.org/pub/software/network/%{name}/%{name}-%{version}.tar.xz
Source999:     fivextra.tar.bz2
BuildRequires:	automake, autoconf
Conflicts:      filesystem < 3

%description
This utility allows querying and changing settings such as speed,
port, auto-negotiation, PCI locations and checksum offload on many
network devices, especially of Ethernet devices.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -n %{name}-%{version}%{?pre} -a 999

# Only needed when using upstream git
# aclocal
# autoheader
# automake --gnu --add-missing --copy
# autoconf

%build
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make DESTDIR=%{buildroot} INSTALL='install -p' install

# Steps to package the ethtool tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%doc AUTHORS ChangeLog* COPYING LICENSE NEWS README
%{_sbindir}/%{name}
%{_mandir}/man8/%{name}.8*

%files fivextra
%{prefix}

%changelog
* Fri May 10 2013 baseuser@ibm.com
- Base-8.x spec file
