# SystemTap support is enabled by default
%if 0%{?cross_build}
%{!?sdt:%global sdt 0}
%endif
%{!?sdt:%global sdt 1}

#http://lists.fedoraproject.org/pipermail/devel/2011-August/155358.html
%global _hardened_build 1

# Where dhcp configuration files are stored
%global dhcpconfdir %{_sysconfdir}/dhcp


#%%global patchver P2
#%%global prever rc1

#%%global VERSION %{version}-%{patchver}
#%%global VERSION %{version}%{prever}
%global VERSION %{version}

Summary:  Dynamic host configuration protocol software
Name:     dhcp
Version:  4.2.5
%define base_release .2
Release:  23%{?dist}%{?base_release}
# NEVER CHANGE THE EPOCH on this package.  The previous maintainer (prior to
# dcantrell maintaining the package) made incorrect use of the epoch and
# that's why it is at 12 now.  It should have never been used, but it was.
# So we are stuck with it.
Epoch:    12
License:  ISC
Group:    System Environment/Daemons
URL:      http://isc.org/products/DHCP/
Source0:  ftp://ftp.isc.org/isc/dhcp/%{VERSION}/dhcp-%{VERSION}.tar.gz
Source1:  dhclient-script
Source2:  README.dhclient.d
Source3:  11-dhclient
Source4:  12-dhcpd
Source5:  56dhclient
Source6:  dhcpd.service
Source7:  dhcpd6.service
Source8:  dhcrelay.service
Source999: fivextra.tar.bz2


Patch0:   dhcp-4.2.0-errwarn-message.patch
Patch1:   dhcp-4.2.4-dhclient-options.patch
Patch2:   dhcp-4.2.0-release-by-ifup.patch
Patch3:   dhcp-4.2.0-dhclient-decline-backoff.patch
Patch4:   dhcp-4.2.4-unicast-bootp.patch
Patch7:   dhcp-4.2.0-default-requested-options.patch
Patch8:   dhcp-4.2.2-xen-checksum.patch
Patch10:  dhcp-4.2.5-manpages.patch
Patch11:  dhcp-4.2.4-paths.patch
Patch12:  dhcp-4.2.2-CLOEXEC.patch
Patch14:  dhcp-4.2.0-garbage-chars.patch
Patch17:  dhcp-4.2.0-add_timeout_when_NULL.patch
Patch18:  dhcp-4.2.4-64_bit_lease_parse.patch
Patch19:  dhcp-4.2.2-capability.patch
Patch20:  dhcp-4.2.0-logpid.patch
Patch21:  dhcp-4.2.4-UseMulticast.patch
Patch22:  dhcp-4.2.5-sendDecline.patch
Patch23:  dhcp-4.2.1-retransmission.patch
Patch25:  dhcp-4.2.5-rfc3442-classless-static-routes.patch
Patch27:  dhcp-4.2.0-honor-expired.patch
Patch28:  dhcp-4.2.5-remove-bind.patch
Patch29:  dhcp-4.2.4-P1-remove-dst.patch
Patch30:  dhcp-4.2.5-sharedlib.patch
Patch31:  dhcp-4.2.5-PPP.patch
Patch32:  dhcp-4.2.5-paranoia.patch
Patch33:  dhcp-4.2.5-lpf-ib.patch
Patch34:  dhcp-4.2.4-improved-xid.patch
Patch35:  dhcp-4.2.2-gpxe-cid.patch
Patch36:  dhcp-4.2.5-systemtap.patch
Patch37:  dhcp-4.2.3-dhclient-decline-onetry.patch
Patch38:  dhcp-4.2.3-P2-log_perror.patch
Patch39:  dhcp-4.2.4-getifaddrs.patch
Patch40:  dhcp-4.2.5-omapi-leak.patch
Patch41:  dhcp-4.2.5-rfc5970-dhcpv6-options-for-network-boot.patch
Patch42:  dhcp-4.2.4-failOverPeer.patch 
Patch43:  dhcp-4.2.5b1-atf-pkgconfig.patch
Patch44:  dhcp-4.2.4-P1-interval.patch
Patch45:  dhcp-4.2.4-P2-conflex-do-forward-updates.patch
Patch46:  dhcp-4.2.4-P2-dupl-key.patch
Patch47:  dhcp-4.2.5-range6.patch
Patch48:  dhcp-4.2.5-next-server.patch
Patch49:  dhcp-bindtodevice-inet6.patch
Patch50:  dhcp-no-subnet-error2info.patch

# Base patches
Patch70153: bug-70153-hex-print-iaids.patch

BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libtool
BuildRequires: openldap-devel
BuildRequires: libcap-ng-devel
BuildRequires: bind-lite-devel
BuildRequires: systemd
%if ! 0%{?base}
# %%check
# there's no atf package in RHEL
BuildRequires: atf libatf-c-devel
%endif
%if %sdt
BuildRequires: systemtap-sdt-devel
%global tapsetdir    /usr/share/systemtap/tapset
%endif

Requires: %{name}-common = %{epoch}:%{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
Requires(pre): shadow-utils
Requires(post): coreutils
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd

# In _docdir we ship some perl scripts and module from contrib subdirectory.
# Because nothing under _docdir is allowed to "require" anything,
# prevent _docdir from being scanned. (#674058)
%filter_requires_in %{_docdir}
%filter_setup

%description
DHCP (Dynamic Host Configuration Protocol) is a protocol which allows
individual devices on an IP network to get their own network
configuration information (IP address, subnetmask, broadcast address,
etc.) from a DHCP server. The overall purpose of DHCP is to make it
easier to administer a large network.

To use DHCP on your network, install a DHCP service (or relay agent),
and on clients run a DHCP client daemon.  The dhcp package provides
the ISC DHCP service and relay agent.

%package -n dhclient
Summary: Provides the ISC DHCP client daemon and dhclient-script
Group: System Environment/Base
# dhclient-script requires:
Requires: coreutils grep hostname initscripts iproute iputils sed
Requires: %{name}-common = %{epoch}:%{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}

%description -n dhclient
DHCP (Dynamic Host Configuration Protocol) is a protocol which allows
individual devices on an IP network to get their own network
configuration information (IP address, subnetmask, broadcast address,
etc.) from a DHCP server. The overall purpose of DHCP is to make it
easier to administer a large network.

To use DHCP on your network, install a DHCP service (or relay agent),
and on clients run a DHCP client daemon.  The dhclient package
provides the ISC DHCP client daemon.

%package common
Summary: Common files used by ISC dhcp client and server
Group: System Environment/Base
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}

%description common
DHCP (Dynamic Host Configuration Protocol) is a protocol which allows
individual devices on an IP network to get their own network
configuration information (IP address, subnetmask, broadcast address,
etc.) from a DHCP server. The overall purpose of DHCP is to make it
easier to administer a large network.

This package provides common files used by dhcp and dhclient package.

%package libs
Summary: Shared libraries used by ISC dhcp client and server
Group: System Environment/Base

%description libs
This package contains shared libraries used by ISC dhcp client and server


%package devel
Summary: Development headers and libraries for interfacing to the DHCP server
Group: Development/Libraries
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}

%description devel
Header files and API documentation for using the ISC DHCP libraries.  The
libdhcpctl and libomapi static libraries are also included in this package.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n dhcp-%{VERSION} -a 999

# Remove bundled BIND source
rm bind/bind.tar.gz

# Remove libdst
rm -rf dst/
rm -rf includes/isc-dhcp

# Fire away bundled BIND source.
%patch28 -p1 -b .remove-bind %{?_rawbuild}

# Fire away libdst
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #30692])
%patch29 -p1 -b .remove-dst %{?_rawbuild}

# Replace the standard ISC warning message about requesting help with an
# explanation that this is a patched build of ISC DHCP and bugs should be
# reported through bugzilla.redhat.com
%patch0 -p1 -b .errwarn

# Add more dhclient options (-I, -B, -H, -F, -timeout, -V, and -R)
%patch1 -p1 -b .options

# Handle releasing interfaces requested by /sbin/ifup
# pid file is assumed to be /var/run/dhclient-$interface.pid
%patch2 -p1 -b .ifup

# If we receive a DHCP offer in dhclient and it's DECLINEd in dhclient-script,
# backoff for an amount of time before trying again
%patch3 -p1 -b .backoff

# Support unicast BOOTP for IBM pSeries systems (and maybe others)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #19146])
%patch4 -p1 -b .unicast

# Add NIS domain, NIS servers, NTP servers, interface-mtu and domain-search
# to the list of default requested DHCP options
%patch7 -p1 -b .requested

# Handle partial UDP checksums (#221964)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #22806] - by Michael S. Tsirkin)
# http://comments.gmane.org/gmane.comp.emulators.kvm.devel/65236
# https://lists.isc.org/pipermail/dhcp-hackers/2010-April/001835.html
%patch8 -p1 -b .xen

# Various man-page-only fixes
%patch10 -p1 -b .man

# Change paths to conform to our standards
%patch11 -p1 -b .paths

# Make sure all open file descriptors are closed-on-exec for SELinux (#446632)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #19148])
%patch12 -p1 -b .cloexec

# Fix 'garbage in format string' error (#450042)
%patch14 -p1 -b .garbage

# Handle cases in add_timeout() where the function is called with a NULL
# value for the 'when' parameter
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #19867])
%patch17 -p1 -b .dracut

# Ensure 64-bit platforms parse lease file dates & times correctly (#448615, #628258)
# (Partly submitted to dhcp-bugs@isc.org - [ISC-Bugs #22033])
%patch18 -p1 -b .64-bit_lease_parse

# Drop unnecessary capabilities in
# dhclient (#517649, #546765), dhcpd/dhcrelay (#699713)
%patch19 -p1 -b .capability

# dhclient logs its pid to make troubleshooting NM managed systems
# with multiple dhclients running easier (#546792)
%patch20 -p1 -b .logpid

# Discard unicast Request/Renew/Release/Decline message
# (unless we set unicast option) and respond with Reply
# with UseMulticast Status Code option (#573090)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #21235])
%patch21 -p1 -b .UseMulticast

# If any of the bound addresses are found to be in use on the link,
# the dhcpv6 client sends a Decline message to the server
# as described in section 18.1.7 of RFC-3315 (#559147)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #21237])
%patch22 -p1 -b .sendDecline

# In client initiated message exchanges stop retransmission
# upon reaching the MRD rather than at some point after it (#559153)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #21238])
%patch23 -p1 -b .retransmission

# RFC 3442 - Classless Static Route Option for DHCPv4 (#516325)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #24572])
%patch25 -p1 -b .rfc3442

# check whether there is any unexpired address in previous lease
# prior to confirming (INIT-REBOOT) the lease (#585418)
# (Submitted to dhcp-suggest@isc.org - [ISC-Bugs #22675])
%patch27 -p1 -b .honor-expired

#Build dhcp's libraries as shared libs instead of static libs.
%patch30 -p1 -b .sharedlib

# DHCPv6 over PPP support (#626514)
%patch31 -p1 -b .PPP

# dhcpd: BEFORE changing of the effective user/group ID:
#  - write PID file (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #25806])
#  - chown leases file (#866714)
%patch32 -p1 -b .paranoia

# IPoIB support (#660681)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #24249])
%patch33 -p1 -b .lpf-ib
%patch34 -p1 -b .improved-xid
%patch35 -p1 -b .gpxe-cid

# http://sourceware.org/systemtap/wiki/SystemTap
%patch36 -p1 -b .systemtap

# Send DHCPDECLINE and exit(2) when duplicate address was detected and
# dhclient had been started with '-1' (#756759).
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #26735])
%patch37 -p1 -b .decline-onetry

# Don't send log messages to the standard error descriptor by default (#790387)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #28049])
%patch38 -p1 -b .log_perror

# Use getifaddrs() to scan for interfaces on Linux (#449946)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #28761])
%patch39 -p1 -b .getifaddrs

# Fix several memory leaks in omapi (#978420)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #33990])
%patch40 -p1 -b .leak

# RFC5970 - DHCPv6 Options for Network Boot (#798735)
%patch41 -p1 -b .rfc5970

# Dhcpd does not correctly follow DhcpFailOverPeerDN (#838400)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #30402])
%patch42 -p1 -b .failOverPeer

# To be able to build with '--with-atf'.
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #32206])
%patch43 -p1 -b .pkgconfig

# isc_time_nowplusinterval() is not safe with 64-bit time_t (#662254, #789601)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #28038])
%patch44 -p1 -b .interval

# do-forward-updates statement wasn't recognized (#863646)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #31328])
%patch45 -p1 -b .forward-updates

# multiple key statements in zone definition causes inappropriate error (#873794)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #31892])
%patch46 -p1 -b .dupl-key

# Make sure range6 is correct for subnet6 where it's declared (#902966)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #32453])
%patch47 -p1 -b .range6

# Expose next-server DHCPv4 option to dhclient script
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #33098])
%patch48 -p1 -b .next-server

# dhclient -6: bind socket to interface (#1001742)
# (Submitted to dhcp-bugs@isc.org - [ISC-Bugs #34784])
%patch49 -p1 -b .bindtodevice_inet6

# 'No subnet declaration for <iface>' should be info, not error.
%patch50 -p1 -b .error2info

# Base patches
%patch70153 -p1 -b .bug-70153

# Update paths in all man pages
for page in client/dhclient.conf.5 client/dhclient.leases.5 \
            client/dhclient-script.8 client/dhclient.8 ; do
    %{__sed} -i -e 's|CLIENTBINDIR|%{_sbindir}|g' \
                -e 's|RUNDIR|%{_localstatedir}/run|g' \
                -e 's|DBDIR|%{_localstatedir}/lib/dhclient|g' \
                -e 's|ETCDIR|%{dhcpconfdir}|g' $page
done

for page in server/dhcpd.conf.5 server/dhcpd.leases.5 server/dhcpd.8 ; do
    %{__sed} -i -e 's|CLIENTBINDIR|%{_sbindir}|g' \
                -e 's|RUNDIR|%{_localstatedir}/run|g' \
                -e 's|DBDIR|%{_localstatedir}/lib/dhcpd|g' \
                -e 's|ETCDIR|%{dhcpconfdir}|g' $page
done

%build
#libtoolize --copy --force
autoreconf --verbose --force --install

CFLAGS="%{optflags} -fno-strict-aliasing" \
%configure \
    --with-srv-lease-file=%{_localstatedir}/lib/dhcpd/dhcpd.leases \
    --with-srv6-lease-file=%{_localstatedir}/lib/dhcpd/dhcpd6.leases \
    --with-cli-lease-file=%{_localstatedir}/lib/dhclient/dhclient.leases \
    --with-cli6-lease-file=%{_localstatedir}/lib/dhclient/dhclient6.leases \
    --with-srv-pid-file=%{_localstatedir}/run/dhcpd.pid \
    --with-srv6-pid-file=%{_localstatedir}/run/dhcpd6.pid \
    --with-cli-pid-file=%{_localstatedir}/run/dhclient.pid \
    --with-cli6-pid-file=%{_localstatedir}/run/dhclient6.pid \
    --with-relay-pid-file=%{_localstatedir}/run/dhcrelay.pid \
    --with-ldap \
    --with-ldapcrypto \
    --with-libbind=%{_includedir} --with-libbind-libs=%{_libdir} \
    --disable-static \
%if %sdt
    --enable-systemtap \
    --with-tapset-install-dir=%{tapsetdir} \
%endif
%if ! 0%{?base}
    --with-atf \
%endif
    --enable-paranoia --enable-early-chroot
%{__make} %{?_smp_mflags}

pushd fivextra
make all
popd

%if 0%{?fedora}
%check
%{__make} check
%endif

%install
%{__make} install DESTDIR=%{buildroot}

# We don't want example conf files in /etc
%{__rm} -f %{buildroot}%{_sysconfdir}/dhclient.conf.example
%{__rm} -f %{buildroot}%{_sysconfdir}/dhcpd.conf.example

# dhclient-script
%{__mkdir} -p %{buildroot}%{_sbindir}
%{__install} -p -m 0755 %{SOURCE1} %{buildroot}%{_sbindir}/dhclient-script

# README.dhclient.d
%{__install} -p -m 0644 %{SOURCE2} .

# Empty directory for dhclient.d scripts
%{__mkdir} -p %{buildroot}%{dhcpconfdir}/dhclient.d

# NetworkManager dispatcher script
%{__mkdir} -p %{buildroot}%{_sysconfdir}/NetworkManager/dispatcher.d
%{__install} -p -m 0755 %{SOURCE3} %{buildroot}%{_sysconfdir}/NetworkManager/dispatcher.d
%{__install} -p -m 0755 %{SOURCE4} %{buildroot}%{_sysconfdir}/NetworkManager/dispatcher.d

# pm-utils script to handle suspend/resume and dhclient leases
%{__mkdir} -p %{buildroot}%{_libdir}/pm-utils/sleep.d
%{__install} -p -m 0755 %{SOURCE5} %{buildroot}%{_libdir}/pm-utils/sleep.d

# systemd unit files
mkdir -p %{buildroot}%{_unitdir}
install -m 644 %{SOURCE6} %{buildroot}%{_unitdir}
install -m 644 %{SOURCE7} %{buildroot}%{_unitdir}
install -m 644 %{SOURCE8} %{buildroot}%{_unitdir}

# Start empty lease databases
%{__mkdir} -p %{buildroot}%{_localstatedir}/lib/dhcpd/
touch %{buildroot}%{_localstatedir}/lib/dhcpd/dhcpd.leases
touch %{buildroot}%{_localstatedir}/lib/dhcpd/dhcpd6.leases
%{__mkdir} -p %{buildroot}%{_localstatedir}/lib/dhclient/

# default sysconfig file for dhcpd
%{__mkdir} -p %{buildroot}%{_sysconfdir}/sysconfig
%{__cat} <<EOF > %{buildroot}%{_sysconfdir}/sysconfig/dhcpd
# WARNING: This file is NOT used anymore.

# If you are here to restrict what interfaces should dhcpd listen on,
# be aware that dhcpd listens *only* on interfaces for which it finds subnet
# declaration in dhcpd.conf. It means that explicitly enumerating interfaces
# also on command line should not be required in most cases.

# If you still insist on adding some command line options,
# copy dhcpd.service from /lib/systemd/system to /etc/systemd/system and modify
# it there.
# https://fedoraproject.org/wiki/Systemd#How_do_I_customize_a_unit_file.2F_add_a_custom_unit_file.3F

# example:
# $ cp /usr/lib/systemd/system/dhcpd.service /etc/systemd/system/
# $ vi /etc/systemd/system/dhcpd.service
# $ ExecStart=/usr/sbin/dhcpd -f -cf /etc/dhcp/dhcpd.conf -user dhcpd -group dhcpd --no-pid <your_interface_name(s)>
# $ systemctl --system daemon-reload
# $ systemctl restart dhcpd.service
EOF

# Copy sample conf files into position (called by doc macro)
%{__cp} -p doc/examples/dhclient-dhcpv6.conf client/dhclient6.conf.example
%{__cp} -p doc/examples/dhcpd-dhcpv6.conf server/dhcpd6.conf.example

# Install default (empty) dhcpd.conf:
%{__mkdir} -p %{buildroot}%{dhcpconfdir}
%{__cat} << EOF > %{buildroot}%{dhcpconfdir}/dhcpd.conf
#
# DHCP Server Configuration file.
#   see /usr/share/doc/dhcp*/dhcpd.conf.example
#   see dhcpd.conf(5) man page
#
EOF

# Install default (empty) dhcpd6.conf:
%{__cat} << EOF > %{buildroot}%{dhcpconfdir}/dhcpd6.conf
#
# DHCPv6 Server Configuration file.
#   see /usr/share/doc/dhcp*/dhcpd6.conf.example
#   see dhcpd.conf(5) man page
#
EOF

# Install dhcp.schema for LDAP configuration
%{__mkdir} -p %{buildroot}%{_sysconfdir}/openldap/schema
%{__install} -p -m 0644 -D contrib/ldap/dhcp.schema \
    %{buildroot}%{_sysconfdir}/openldap/schema

# Don't package libtool *.la files
find ${RPM_BUILD_ROOT}/%{_libdir} -name '*.la' -exec '/bin/rm' '-f' '{}' ';';

# Steps to package the dhcp tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%pre
# /usr/share/doc/setup/uidgid
%global gid_uid 177
getent group dhcpd >/dev/null || groupadd --force --gid %{gid_uid} --system dhcpd
if ! getent passwd dhcpd >/dev/null ; then
    if ! getent passwd %{gid_uid} >/dev/null ; then
      useradd --system --uid %{gid_uid} --gid dhcpd --home / --shell /sbin/nologin --comment "DHCP server" dhcpd
    else
      useradd --system --gid dhcpd --home / --shell /sbin/nologin --comment "DHCP server" dhcpd
    fi
fi
exit 0

%post
# Initial installation
%systemd_post dhcpd.service dhcpd6.service dhcrelay.service

# Update
if [ $1 -gt 1 ] ; then
  chown -R dhcpd:dhcpd %{_localstatedir}/lib/dhcpd/
fi


%preun
# Package removal, not upgrade
%systemd_preun dhcpd.service dhcpd6.service dhcrelay.service


%postun
# Package upgrade, not uninstall
%systemd_postun_with_restart dhcpd.service dhcpd6.service dhcrelay.service


%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%triggerun -- dhcp
# convert DHC*ARGS from /etc/sysconfig/dhc* to /etc/systemd/system/dhc*.service
for servicename in dhcpd dhcpd6 dhcrelay; do
  if [ -f %{_sysconfdir}/sysconfig/${servicename} ]; then
    # get DHCPDARGS/DHCRELAYARGS value from /etc/sysconfig/${servicename}
    source %{_sysconfdir}/sysconfig/${servicename}
    if [ "${servicename}" == "dhcrelay" ]; then
        args=$DHCRELAYARGS
    else
        args=$DHCPDARGS
    fi
    # value is non-empty (i.e. user modified) and there isn't a service unit yet
    if [ -n "${args}" -a ! -f %{_sysconfdir}/systemd/system/${servicename}.service ]; then
      # in $args replace / with \/ otherwise the next sed won't take it
      args=$(echo $args | sed 's/\//\\\//'g)
      # add $args to the end of ExecStart line
      sed -r -e "/ExecStart=/ s/$/ ${args}/" \
                < %{_unitdir}/${servicename}.service \
                > %{_sysconfdir}/systemd/system/${servicename}.service
    fi
  fi
done

%files
%doc server/dhcpd.conf.example server/dhcpd6.conf.example
%doc contrib/ldap/
%attr(0750,root,root) %dir %{dhcpconfdir}
%attr(0755,dhcpd,dhcpd) %dir %{_localstatedir}/lib/dhcpd
%attr(0644,dhcpd,dhcpd) %verify(mode) %config(noreplace) %{_localstatedir}/lib/dhcpd/dhcpd.leases
%attr(0644,dhcpd,dhcpd) %verify(mode) %config(noreplace) %{_localstatedir}/lib/dhcpd/dhcpd6.leases
%config(noreplace) %{_sysconfdir}/sysconfig/dhcpd
%config(noreplace) %{dhcpconfdir}/dhcpd.conf
%config(noreplace) %{dhcpconfdir}/dhcpd6.conf
%config(noreplace) %{_sysconfdir}/openldap/schema/dhcp.schema
%dir %{_sysconfdir}/NetworkManager
%dir %{_sysconfdir}/NetworkManager/dispatcher.d
%{_sysconfdir}/NetworkManager/dispatcher.d/12-dhcpd
%attr(0644,root,root)   %{_unitdir}/dhcpd.service
%attr(0644,root,root)   %{_unitdir}/dhcpd6.service
%attr(0644,root,root)   %{_unitdir}/dhcrelay.service
%{_sbindir}/dhcpd
%{_sbindir}/dhcrelay
%{_bindir}/omshell
%attr(0644,root,root) %{_mandir}/man1/omshell.1.gz
%attr(0644,root,root) %{_mandir}/man5/dhcpd.conf.5.gz
%attr(0644,root,root) %{_mandir}/man5/dhcpd.leases.5.gz
%attr(0644,root,root) %{_mandir}/man8/dhcpd.8.gz
%attr(0644,root,root) %{_mandir}/man8/dhcrelay.8.gz
%if %sdt
%{tapsetdir}/*.stp
%endif

%files -n dhclient
%doc client/dhclient.conf.example client/dhclient6.conf.example README.dhclient.d
%attr(0750,root,root) %dir %{dhcpconfdir}
%dir %{dhcpconfdir}/dhclient.d
%dir %{_localstatedir}/lib/dhclient
%dir %{_sysconfdir}/NetworkManager
%dir %{_sysconfdir}/NetworkManager/dispatcher.d
%{_sysconfdir}/NetworkManager/dispatcher.d/11-dhclient
%{_sbindir}/dhclient
%{_sbindir}/dhclient-script
%attr(0755,root,root) %{_libdir}/pm-utils/sleep.d/56dhclient
%attr(0644,root,root) %{_mandir}/man5/dhclient.conf.5.gz
%attr(0644,root,root) %{_mandir}/man5/dhclient.leases.5.gz
%attr(0644,root,root) %{_mandir}/man8/dhclient.8.gz
%attr(0644,root,root) %{_mandir}/man8/dhclient-script.8.gz

%files common
%doc LICENSE README RELNOTES doc/References.txt
%attr(0644,root,root) %{_mandir}/man5/dhcp-options.5.gz
%attr(0644,root,root) %{_mandir}/man5/dhcp-eval.5.gz

%files libs
%{_libdir}/libdhcpctl.so.*
%{_libdir}/libomapi.so.*

%files devel
%doc doc/IANA-arp-parameters doc/api+protocol
%{_includedir}/dhcpctl
%{_includedir}/omapip
%{_libdir}/libdhcpctl.so
%{_libdir}/libomapi.so
%attr(0644,root,root) %{_mandir}/man3/dhcpctl.3.gz
%attr(0644,root,root) %{_mandir}/man3/omapi.3.gz

%files fivextra
%{prefix}


%changelog
* Sat Jan 25 2014 baseuser@ibm.com
- Base-f19.x spec file
