# ----
# KVM On Power spec file
# ----

%define pkvm_version 3.4.3
%define pkvm_release 39
%define pkvm_respin .0

Name:      powerkvm-installer
Version:   %{pkvm_version}
Release:   %{pkvm_release}%{?pkvm_respin}%{?dist}
License:   EPL
Vendor:    IBM
Packager:  LTC
Group:     Application
Summary:   %{label} installer
Source:    powerkvm.tar.gz
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}
Requires:  newt-python, python-pycurl, rpm-python

%description
%{label} installer tool

# Use MD5 for file digest (backwards compatible)
%global _binary_filedigest_algorithm 1
%global _source_filedigest_algorithm 1

# use gzip compression level 9
%global _binary_payload w9.gzdio
%global _source_payload w9.gzdio

%prep
%setup -n %{name}

%install
cp -a ./ %{buildroot}
find %{buildroot} -name .gitignore -exec rm {} \;

ln -s /usr/bin/ibm-configure-system %{buildroot}/usr/bin/configure-system

%post
# Do not print LVM warning in output - breaks newt screen
echo "export LVM_SUPPRESS_FD_WARNINGS=1" >> /etc/profile
# Do no print Kernel stuff in output - breaks newt screen
echo "kernel.printk = 3 4 1 3" >> /etc/sysctl.conf


%clean

%files
%defattr(-,root,root)
/opt/ibm/powerkvm/*
%dir /opt/ibm/powerkvm
%config %{_sysconfdir}/fstab
%config %{_sysconfdir}/multipath.conf
%config %{_sysconfdir}/sysconfig/network
/usr/bin/powerkvm
/usr/bin/ibm-configure-system
/usr/bin/ibm-update-system
/usr/bin/configure-system
