/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.tracing.brave.internal;

import java.net.URI;
import java.util.List;
import java.util.Map;

public abstract class HttpAdapterFactory {
    public static final class Request {
        private final Map<String, List<String>> headers;
        private final URI uri;
        private final String method;
        
        Request(Map<String, List<String>> headers, URI uri, String method) {
            this.headers = headers;
            this.uri = uri;
            this.method = method;
        }
        
        Map<String, List<String>> headers() {
            return headers;
        }
        
        URI uri() {
            return uri;
        }
        
        String method() {
            return method;
        }
    }
    
    public static final class Response {
        private final Integer status;
        
        Response(Integer status) {
            this.status = status;
        }
        
        Integer status() {
            return status;
        }
    }
    
    public static Request request(Map<String, List<String>> headers, URI uri, String method) {
        return new Request(headers, uri, method);
    }
    
    public static Response response(Integer status) {
        return new Response(status);
    }
}
