# Upstream Community Theme

The Upstream Community Theme is a ready-to-use [Jekyll](https://jekyllrb.com/) theme to help you create a basic static site for your project. It was designed with the Red Hat Upstream Community in mind, but can be used by anyone looking to create a simple, lightweight site.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development purposes. See deployment for notes on how to deploy the project on [GitHub Pages](https://pages.github.com/).

### Prerequisites

 - Install a full [Ruby development environment](https://www.ruby-lang.org/en/downloads/). Ruby version 2.4.0 or above is required, including all development headers. You can run `ruby -v` to check your current Ruby version.
 - [RubyGems](https://rubygems.org/pages/download). You can run `gem -v` to check if you have RubyGems installed.
 - [GCC](https://gcc.gnu.org/install/) and [Make](https://www.gnu.org/software/make/). You can run `gcc -v`,`g++ -v` and `make -v` to see if your system already has them installed.

### Installing the theme

*[Jekyll documentation pages](https://jekyllrb.com/docs/)*

1. The Jekyll site provides detailed installation instructions for each operating system:
 
  - [Mac](https://jekyllrb.com/docs/installation/macos/)
  - [Linux distributions including Red Hat Linux](https://jekyllrb.com/docs/installation/other-linux)
  - [Ubuntu Linux](https://jekyllrb.com/docs/installation/ubuntu/)
  - [Windows](https://jekyllrb.com/docs/installation/windows/)
    
2. Fork this repository by clicking the _Fork_ button at the top right corner of this page.
3. Clone your fork (please ensure you have current version of git installed) by running: 
  `git clone git@github.com:YOUR_USER_NAME/dekorate.git`
4. Change into the project directory
  `cd dekorate/docs`
5. Build the site and make it available on a local server
  `bundle exec jekyll serve`
6. To preview your site, browse to http://localhost:4000

> If you encounter any unexpected errors during the above, please refer to the [troubleshooting](https://jekyllrb.com/docs/troubleshooting/#configuration-problems) page or the [requirements](https://jekyllrb.com/docs/installation/#requirements) page, as you might be missing development headers or other prerequisites.

_For more information regarding the use of Jekyll, please refer to the [Jekyll Step by Step Tutorial](https://jekyllrb.com/docs/step-by-step/01-setup/)._

### Installing the theme using Docker

Alternatively, you can build the site and make it available on a local server using Docker without needing to install any tools in your local machine:

```
cd docs
docker run -p 4000:4000 -v $(pwd):/site bretfisher/jekyll-serve
```

The site will be up and running in `localhost:4000`.

Or you can just use docker compose:

```
docker compose up
```


## Deployment on GitHub Pages

To deploy your site using GitHub Pages you will need to add the [github-pages gem](https://github.com/github/pages-gem).

To use the github-pages gem, you'll need to add the following on your `Gemfile`:

```
source "https://rubygems.org"
gem "github-pages", group: :jekyll_plugins
```
And then run `bundle update`.

To deploy a project page that is kept in the same repository as the project they are for, please refer to the *Project Pages* section in [Deploying Jekyll to GitHub Pages](https://jekyllrb.com/docs/github-pages/#deploying-jekyll-to-github-pages).


## Contributing

Please read [CONTRIBUTING.md](https://gist.github.com/PurpleBooth/b24679402957c63ec426) for details on the process for submitting pull requests to us.

## Authors

* [**Adela Sofia A.**](https://github.com/adelasofia) - *Initial theme implementation*
* [**Jason Brock**](https://github.com/jkbrock) - *Visual Designer*

## License

This project is licensed under the MIT License - see the [LICENSE.txt](../license.txt) file for details.

## Navigation

The side navigation bars make use of the `/_data/sidebar.yml` file, here you can write down the title and url where you want to page to be reached at. It will automatically be added to the website.
Please make sure the `url` here is the same as the `permalink` inside the page front matter.

For example:

`sidebar.yml` -
```
 title: Getting Started
 url: /docs/getting-started
```
`docs/getting-started.md` -
```---
title: Getting Started
description: Getting Started
layout: docs
permalink: /docs/getting-started
---
```

In order to create a navigation dropdown follow the following example:
```- title: Usage
    url: /docs/usage
    dropdown:
      - title: Kubernetes
        url: /docs/kubernetes
      - title: Container Resources
        url: /docs/container-resources
```

## Page Layouts

There are a few page layouts:

[comment]: <> (// TO DO: review the layouts part)

[comment]: <> (* `homepage` this is very specific to the homepage and shouldn't be used for other pages)

[comment]: <> (* `docs` this is specific to all the pages that are related to documentation files.)

[comment]: <> (* `default` this can be reused for any other pages. Mention the title in the Front Matter and omit it in the content of your page.)

## Documetation pages

All documentation files should be added to the `documentation/` folder and for the navigation to have `/docs/page-name` in the url.


## Github api

The website uses the [jekyll-github-metadata](https://github.com/jekyll/github-metadata) plugin in order to display new releases automatically,
this can be use for other purposes if need arises
