/*
 * Copyright 2015 Red Hat, Inc.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  and Apache License v2.0 which accompanies this distribution.
 *
 *  The Eclipse Public License is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  The Apache License v2.0 is available at
 *  http://www.opensource.org/licenses/apache2.0.php
 *
 *  You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;

/**
 * @author Paulo Lopes
 */
public interface OAuth2Flow {

  /**
   * See implementations for specific documentation.
   */
  default String authorizeURL(JsonObject params) {
    return null;
  }

  /**
   * See implementations for specific documentation.
   */
  void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler);
}
