/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.ArrayInstruction;
import serp.bytecode.Code;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class ArrayStoreInstruction
extends ArrayInstruction {
    private static final Class[][] _mappings = new Class[][]{{Boolean.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};

    ArrayStoreInstruction(Code owner) {
        super(owner);
    }

    ArrayStoreInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    @Override
    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -3;
    }

    @Override
    public int getStackChange() {
        switch (this.getOpcode()) {
            case 80: 
            case 82: {
                return -4;
            }
            case 0: {
                return 0;
            }
        }
        return -3;
    }

    @Override
    public String getTypeName() {
        switch (this.getOpcode()) {
            case 79: {
                return Integer.TYPE.getName();
            }
            case 80: {
                return Long.TYPE.getName();
            }
            case 81: {
                return Float.TYPE.getName();
            }
            case 82: {
                return Double.TYPE.getName();
            }
            case 83: {
                return Object.class.getName();
            }
            case 84: {
                return Byte.TYPE.getName();
            }
            case 85: {
                return Character.TYPE.getName();
            }
            case 86: {
                return Short.TYPE.getName();
            }
        }
        return null;
    }

    @Override
    public TypedInstruction setType(String type) {
        if ((type = this.mapType(type, _mappings, true)) == null) {
            return (TypedInstruction)this.setOpcode(0);
        }
        switch (type.charAt(0)) {
            case 'i': {
                return (TypedInstruction)this.setOpcode(79);
            }
            case 'l': {
                return (TypedInstruction)this.setOpcode(80);
            }
            case 'f': {
                return (TypedInstruction)this.setOpcode(81);
            }
            case 'd': {
                return (TypedInstruction)this.setOpcode(82);
            }
            case 'b': {
                return (TypedInstruction)this.setOpcode(84);
            }
            case 'c': {
                return (TypedInstruction)this.setOpcode(85);
            }
            case 's': {
                return (TypedInstruction)this.setOpcode(86);
            }
        }
        return (TypedInstruction)this.setOpcode(83);
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterArrayStoreInstruction(this);
        visit.exitArrayStoreInstruction(this);
    }
}

