/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.unifiedpush;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.common.collect.ImmutableSet;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.impl.http.HttpRestProviderForPush;
import org.jboss.aerogear.android.impl.util.UrlUtils;
import org.jboss.aerogear.android.unifiedpush.PushConfig;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;

public class AeroGearGCMPushRegistrar
implements PushRegistrar {
    private static final Integer TIMEOUT = 30000;
    private static final String TAG = AeroGearGCMPushRegistrar.class.getSimpleName();
    public static final String PROPERTY_REG_ID = "registration_id";
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private static final String PROPERTY_ON_SERVER_EXPIRATION_TIME = "onServerExpirationTimeMs";
    private static final String registryDeviceEndpoint = "/rest/registry/device";
    private final PushConfig config;
    private URL deviceRegistryURL;
    public static final long REGISTRATION_EXPIRY_TIME_MS = 604800000L;
    private GoogleCloudMessaging gcm;
    private Provider<HttpRestProviderForPush> httpProviderProvider = new Provider<HttpRestProviderForPush>(){

        @Override
        public HttpRestProviderForPush get(Object ... in) {
            return new HttpRestProviderForPush((URL)in[0], (Integer)in[1]);
        }
    };
    private Provider<GoogleCloudMessaging> gcmProvider = new Provider<GoogleCloudMessaging>(){

        @Override
        public GoogleCloudMessaging get(Object ... context) {
            return GoogleCloudMessaging.getInstance((Context)((Context)context[0]));
        }
    };

    public AeroGearGCMPushRegistrar(PushConfig config) {
        this.config = config;
        this.deviceRegistryURL = UrlUtils.appendToBaseURI(config.getPushServerURI(), registryDeviceEndpoint);
    }

    @Override
    public void register(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    String regid;
                    if (AeroGearGCMPushRegistrar.this.gcm == null) {
                        AeroGearGCMPushRegistrar.this.gcm = (GoogleCloudMessaging)AeroGearGCMPushRegistrar.this.gcmProvider.get(context);
                    }
                    if ((regid = AeroGearGCMPushRegistrar.this.getRegistrationId(context)).length() == 0) {
                        regid = AeroGearGCMPushRegistrar.this.gcm.register((String[])((AeroGearGCMPushRegistrar)AeroGearGCMPushRegistrar.this).config.senderIds.toArray((Object[])new String[0]));
                        AeroGearGCMPushRegistrar.this.setRegistrationId(context, regid);
                    }
                    AeroGearGCMPushRegistrar.this.config.setDeviceToken(regid);
                    HttpRestProviderForPush httpProvider = (HttpRestProviderForPush)AeroGearGCMPushRegistrar.this.httpProviderProvider.get(AeroGearGCMPushRegistrar.this.deviceRegistryURL, TIMEOUT);
                    httpProvider.setPasswordAuthentication(AeroGearGCMPushRegistrar.this.config.getVariantID(), AeroGearGCMPushRegistrar.this.config.getSecret());
                    Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){
                        private final ImmutableSet<String> fields = ImmutableSet.builder().add((Object)"deviceToken").add((Object)"deviceType").add((Object)"alias").add((Object)"operatingSystem").add((Object)"osVersion").add((Object)"categories").build();

                        public boolean shouldSkipField(FieldAttributes f) {
                            return f.getDeclaringClass() != PushConfig.class || !this.fields.contains((Object)f.getName());
                        }

                        public boolean shouldSkipClass(Class<?> arg0) {
                            return false;
                        }
                    }}).create();
                    try {
                        httpProvider.post(gson.toJson((Object)AeroGearGCMPushRegistrar.this.config));
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else if (result instanceof HttpException) {
                    HttpException httpException = (HttpException)result;
                    switch (httpException.getStatusCode()) {
                        case 301: 
                        case 302: 
                        case 307: {
                            Log.w((String)TAG, (String)httpException.getMessage());
                            try {
                                URL redirectURL = new URL(httpException.getHeaders().get("Location"));
                                AeroGearGCMPushRegistrar.this.deviceRegistryURL = redirectURL;
                                AeroGearGCMPushRegistrar.this.register(context, callback);
                            }
                            catch (MalformedURLException e) {
                                callback.onFailure(e);
                            }
                            break;
                        }
                        default: {
                            callback.onFailure(result);
                            break;
                        }
                    }
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    @Override
    public void unregister(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    if (AeroGearGCMPushRegistrar.this.gcm == null) {
                        AeroGearGCMPushRegistrar.this.gcm = (GoogleCloudMessaging)AeroGearGCMPushRegistrar.this.gcmProvider.get(context);
                    }
                    AeroGearGCMPushRegistrar.this.gcm.unregister();
                    HttpRestProviderForPush provider = (HttpRestProviderForPush)AeroGearGCMPushRegistrar.this.httpProviderProvider.get(AeroGearGCMPushRegistrar.this.deviceRegistryURL, TIMEOUT);
                    provider.setPasswordAuthentication(AeroGearGCMPushRegistrar.this.config.getVariantID(), AeroGearGCMPushRegistrar.this.config.getSecret());
                    try {
                        provider.delete(AeroGearGCMPushRegistrar.this.config.getDeviceToken());
                        AeroGearGCMPushRegistrar.this.config.setDeviceToken("");
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    protected String getRegistrationId(Context context) {
        int currentVersion;
        SharedPreferences prefs = this.getGCMPreferences(context);
        String registrationId = prefs.getString(PROPERTY_REG_ID, "");
        if (registrationId.length() == 0) {
            Log.v((String)TAG, (String)"Registration not found.");
            return "";
        }
        int registeredVersion = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
        if (registeredVersion != (currentVersion = AeroGearGCMPushRegistrar.getAppVersion(context)) || this.isRegistrationExpired(context)) {
            Log.v((String)TAG, (String)"App version changed or registration expired.");
            return "";
        }
        return registrationId;
    }

    private SharedPreferences getGCMPreferences(Context context) {
        return context.getSharedPreferences(AeroGearGCMPushRegistrar.class.getSimpleName(), 0);
    }

    private static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get package name: " + (Object)((Object)e));
        }
    }

    private boolean isRegistrationExpired(Context context) {
        SharedPreferences prefs = this.getGCMPreferences(context);
        long expirationTime = prefs.getLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, -1L);
        return System.currentTimeMillis() > expirationTime;
    }

    private void setRegistrationId(Context context, String regId) {
        SharedPreferences prefs = this.getGCMPreferences(context);
        int appVersion = AeroGearGCMPushRegistrar.getAppVersion(context);
        Log.v((String)TAG, (String)("Saving regId on app version " + appVersion));
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_REG_ID, regId);
        editor.putInt(PROPERTY_APP_VERSION, appVersion);
        long expirationTime = System.currentTimeMillis() + 604800000L;
        Log.v((String)TAG, (String)("Setting registration expiry time to " + new Timestamp(expirationTime)));
        editor.putLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, expirationTime);
        editor.commit();
    }
}

